/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac;

import abscon.problem.Variable;
import abscon.propagationTechniques.propagationSets.PropagationSetOfRemovals;
import abscon.solvers.Solver;
import java.util.Arrays;

public class Branch {
    protected Solver solver;
    protected int currentSize;
    protected Variable[] variables;
    protected int[] indexes;
    protected int[] positions;

    public int getCurrentSize() {
        return this.currentSize;
    }

    public Variable getVariable(int i) {
        assert (this.positions[this.variables[i].getId()] != -1);
        return this.variables[i];
    }

    public int getIndex(int i) {
        return this.indexes[i];
    }

    public Branch(Solver solver) {
        this.solver = solver;
        int nbVariables = solver.getNbVariables();
        this.variables = new Variable[nbVariables];
        this.indexes = new int[nbVariables];
        this.positions = new int[nbVariables];
    }

    public void clear() {
        this.currentSize = 0;
        Arrays.fill(this.positions, -1);
    }

    public boolean has(Variable variable) {
        return this.positions[variable.getId()] != -1;
    }

    public void add(Variable variable, int index) {
        assert (!this.has(variable));
        this.variables[this.currentSize] = variable;
        this.indexes[this.currentSize] = index;
        this.positions[variable.getId()] = this.currentSize++;
        assert (this.controlSize());
    }

    public void display() {
        System.out.print("Branch : ");
        int i = 0;
        while (i < this.currentSize) {
            System.out.print(this.variables[i] + "<-" + this.indexes[i] + " ");
            ++i;
        }
        System.out.println();
    }

    public boolean controlSize() {
        int cpt = 0;
        int i = 0;
        while (i < this.positions.length) {
            if (this.positions[i] != -1) {
                ++cpt;
            }
            ++i;
        }
        return cpt == this.currentSize;
    }

    public boolean controlWrt(PropagationSetOfRemovals queue) {
        int i = 0;
        while (i < this.currentSize) {
            if (queue.isPresent(this.variables[i], this.indexes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

