/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.maxCSP;

import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.maxCSP.MaxCSP;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.Branch;
import abscon.solvers.Solver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.math.CompositionMaker;

public class SingletonMaxCSP3Single
extends MaxCSP {
    private Branch branch;
    private boolean maximumBranchExtension = false;
    private int nbSingletonTests;
    private int nbEffectiveSingletonTests;
    protected int nbBuiltBranches;
    protected int cumulBranchSizes;
    private int nbUntestedVariables;
    private boolean[] untestedVariables;
    private Variable lastFailedVariable;
    private int lastFailedIndex;
    private int selectionMode = 0;

    private void setUntested(int position, boolean b) {
        if (this.untestedVariables[position] != b) {
            this.untestedVariables[position] = b;
            this.nbUntestedVariables += b ? 1 : -1;
        }
        assert (this.controlUntested());
    }

    private void initialize() {
        Variable[] variables = this.solver.getVariables();
        int i = 0;
        while (i < this.untestedVariables.length) {
            this.untestedVariables[i] = variables[i].isFuture();
            ++i;
        }
        this.nbUntestedVariables = this.solver.getVariableManager().getNbFutureVariables();
        this.lastFailedVariable = null;
        assert (this.controlUntested());
    }

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        this.untestedVariables = new boolean[solver.getNbVariables()];
        this.branch = new Branch(solver);
    }

    protected void undoAssignmentsFromBranch(Branch branch) {
        int i = branch.getCurrentSize() - 1;
        while (i >= 0) {
            this.solver.undoAssignmentOf(branch.getVariable(i));
            this.solver.undoPropagationOf(branch.getVariable(i));
            --i;
        }
        this.supportManager.restoreSupportsOfFutureVariables(this.solver.getCurrentDepth());
    }

    protected boolean manageInconsistentAssignment(Variable variable, int index) {
        ++this.nbEffectiveSingletonTests;
        variable.getDomain().removeElementAt(index);
        if (variable.getCurrentDomainSize() == 0) {
            this.culprit = variable;
            return false;
        }
        assert (this.propagationSet.controlClear());
        return true;
    }

    protected boolean canTryAnotherExtensionInsteadOf(Variable variable, int index) {
        if (!this.maximumBranchExtension || this.branch.getCurrentSize() == 0) {
            return false;
        }
        variable.getDomain().removeElementAt(index);
        if (variable.getCurrentDomainSize() == 0) {
            return false;
        }
        boolean b = super.checkConsistencyAfterRefutationOf(variable, 0);
        return b;
    }

    protected void dealWithNewBranch(Branch branch) {
        this.undoAssignmentsFromBranch(branch);
        this.cumulBranchSizes += branch.getCurrentSize();
        ++this.nbBuiltBranches;
    }

    private Variable selectNextVariable(boolean onlyUntested) {
        Variable bestVariable = null;
        double bestResult = -9.223372036854776E18;
        VariableManager variableManager = this.solver.getVariableManager();
        Variable future = variableManager.getFirstFutureVariable();
        while (future != null) {
            if (!onlyUntested || this.untestedVariables[future.getId()]) {
                assert (!onlyUntested || !this.branch.has(future));
                double result = 0.0;
                result = this.selectionMode == 0 ? (double)future.getWeightedDegree() / (double)future.getDomain().getCurrentSize() : -CompositionMaker.maxMinD(future.getDomain().getCurrentSize(), future.getDynamicDegree(), this.solver.getProblem().getMaxVariableDegree());
                if (result > bestResult) {
                    bestVariable = future;
                    bestResult = result;
                }
            }
            future = variableManager.getNextFutureVariableAfter(future);
        }
        assert (bestVariable != null) : "onlyUntested = " + onlyUntested;
        return bestVariable;
    }

    protected boolean buildBranch(Branch branch) {
        branch.clear();
        boolean finished = false;
        while (!finished) {
            Variable variable = this.lastFailedVariable != null ? this.lastFailedVariable : this.selectNextVariable(this.nbUntestedVariables > 0);
            int index = this.lastFailedVariable != null ? this.lastFailedIndex : variable.getDomain().getFirstValidIndex();
            this.lastFailedVariable = null;
            assert (!variable.isAssigned());
            assert (variable.getDomain().hasIndex(index));
            assert (this.propagationSet.controlClear());
            ++this.nbSingletonTests;
            this.solver.doAssignment(variable, index);
            boolean consistent = super.checkConsistencyAfterAssignmentOf(variable);
            if (consistent) {
                this.setUntested(variable.getId(), false);
                branch.add(variable, index);
                if (this.solver.getCurrentDepth() != this.solver.getNbVariables()) continue;
                finished = true;
                continue;
            }
            this.solver.undoAssignmentOf(variable);
            this.solver.undoPropagationOf(variable);
            if (branch.getCurrentSize() == 0) {
                return this.manageInconsistentAssignment(variable, index);
            }
            boolean bl = finished = !this.canTryAnotherExtensionInsteadOf(variable, index);
            if (!finished) continue;
            this.lastFailedVariable = variable;
            this.lastFailedIndex = index;
        }
        this.dealWithNewBranch(branch);
        return true;
    }

    protected boolean filterBySAC() {
        VariableManager variableManager = this.solver.getVariableManager();
        if (variableManager.getNbFutureVariables() == 0) {
            return true;
        }
        this.nbBuiltBranches = 0;
        this.cumulBranchSizes = 0;
        this.initialize();
        while (this.nbUntestedVariables > 0) {
            boolean consistent = this.buildBranch(this.branch);
            if (!consistent) {
                return false;
            }
            if (!this.solver.getResolution().isFinished()) continue;
            return true;
        }
        return super.checkConsistencyAfterRefutationOf(null, this.solver.getCurrentDepth() + 1);
    }

    public boolean checkConsistency() {
        this.increment = true;
        if (!super.checkConsistency()) {
            return false;
        }
        return this.filterBySAC();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        return super.checkConsistencyAfterAssignmentOf(variable);
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        return super.checkConsistencyAfterRefutationOf(variable, variableDepth);
    }

    private boolean controlUntested() {
        int cpt = 0;
        int i = 0;
        while (i < this.untestedVariables.length) {
            if (this.untestedVariables[i]) {
                if (!this.solver.getVariable(i).isFuture()) {
                    return false;
                }
                ++cpt;
            }
            ++i;
        }
        return cpt == this.nbUntestedVariables;
    }
}

