/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.maxCSP;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.solvers.Solver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public class MaxCSPOnePass
extends ForwardPropagationTechnique {
    private int upperBound;
    private boolean[][][] inconsistent;
    private int[][] nbDetectedInconsistencies;
    private int[] minDetectedInconsistencies;
    private int[] maxDetectedInconsistencies;
    private int sumMni;
    private int lastInitDepth;
    private ConstraintPartition constraintPartition;

    public void attachTo(Solver solver) {
        if (solver.getProblem().getNbUnaryConstraints() > 0) {
            throw new IncompatiblePropertiesException();
        }
        super.attachTo(solver);
        Constraint[] constraints = solver.getConstraints();
        this.inconsistent = new boolean[constraints.length][][];
        int i = 0;
        while (i < this.inconsistent.length) {
            Variable[] involvedVariables = constraints[i].getInvolvedVariables();
            this.inconsistent[i] = new boolean[involvedVariables.length][];
            int j = 0;
            while (j < this.inconsistent[i].length) {
                this.inconsistent[i][j] = new boolean[involvedVariables[j].getDomain().getMaximumSize()];
                ++j;
            }
            ++i;
        }
        Variable[] variables = solver.getVariables();
        this.minDetectedInconsistencies = new int[variables.length];
        this.maxDetectedInconsistencies = new int[variables.length];
        this.nbDetectedInconsistencies = new int[variables.length][];
        int i2 = 0;
        while (i2 < this.nbDetectedInconsistencies.length) {
            this.nbDetectedInconsistencies[i2] = new int[variables[i2].getDomain().getMaximumSize()];
            ++i2;
        }
        this.constraintPartition = new ConstraintPartition(solver.getNbVariables(), solver.getNbConstraints());
    }

    private int setMni(Variable variable) {
        int[] t = this.nbDetectedInconsistencies[variable.getId()];
        int bestMinIndex = -1;
        int bestMaxIndex = -1;
        Elements elements = variable.getDomain().getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            t[index] = this.constraintPartition.computeNbViolatedConstraintsInvolving(variable, index);
            if (bestMinIndex == -1) {
                bestMinIndex = index;
                bestMaxIndex = index;
            } else if (t[index] < t[bestMinIndex]) {
                bestMinIndex = index;
            } else if (t[index] > t[bestMaxIndex]) {
                bestMaxIndex = index;
            }
            index = elements.getNextPresent(index);
        }
        this.minDetectedInconsistencies[variable.getId()] = bestMinIndex;
        this.maxDetectedInconsistencies[variable.getId()] = bestMaxIndex;
        return t[bestMinIndex];
    }

    private boolean propagate() {
        this.propagationSet.clear();
        VariableManager vm = this.solver.getVariableManager();
        Variable variable = vm.getFirstFutureVariable();
        while (variable != null) {
            int[] t = this.nbDetectedInconsistencies[variable.getId()];
            int base = this.constraintPartition.nbViolatedPastConstraints + this.sumMni - t[this.minDetectedInconsistencies[variable.getId()]];
            if (base + t[this.maxDetectedInconsistencies[variable.getId()]] >= this.upperBound) {
                Domain domain = variable.getDomain();
                int domainSizeBefore = domain.getCurrentSize();
                Elements elements = domain.getElements();
                int index = elements.getFirstPresent();
                while (index != -1) {
                    assert (t[index] == this.constraintPartition.computeNbViolatedConstraintsInvolving(variable, index));
                    if (base + t[index] >= this.upperBound) {
                        domain.removeElementAt(index, null, 0);
                    }
                    index = elements.getNextPresent(index);
                }
                int nbRemovals = domainSizeBefore - domain.getCurrentSize();
                if (nbRemovals > 0) {
                    if (domain.isEmpty()) {
                        variable.incrementWeightedDegree();
                        return false;
                    }
                    this.propagationSet.updateAfterEffectiveRevisionOf(null, variable, nbRemovals);
                }
            }
            variable = vm.getNextFutureVariableAfter(variable);
        }
        return true;
    }

    private boolean go() {
        this.constraintPartition.init();
        int currentDistance = this.constraintPartition.nbViolatedPastConstraints;
        int maxFutureDistance = this.solver.getNbConstraints() - this.constraintPartition.nbPastConstraints;
        if (currentDistance + maxFutureDistance < this.upperBound) {
            return true;
        }
        this.sumMni = 0;
        VariableManager vm = this.solver.getVariableManager();
        Variable variable = vm.getFirstFutureVariable();
        while (variable != null) {
            this.sumMni += this.setMni(variable);
            if (currentDistance + this.sumMni >= this.upperBound) {
                return false;
            }
            variable = vm.getNextFutureVariableAfter(variable);
        }
        return this.propagate();
    }

    public boolean checkConsistency() {
        this.upperBound = this.solver.getNbConstraints() + 1;
        return this.go();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        boolean consistent = this.go();
        if (consistent && this.solver.getVariableManager().areAllPastVariables()) {
            this.upperBound = this.constraintPartition.nbViolatedPastConstraints;
            System.out.println("cost = " + this.upperBound);
        }
        return consistent;
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        return this.go();
    }

    class ConstraintPartition {
        int[] membership;
        int[] next;
        int[] head;
        int[] size;
        int pastHead;
        int nbPastConstraints;
        int nbViolatedPastConstraints;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ConstraintPartition.class.desiredAssertionStatus();
        }

        ConstraintPartition(int nbVariables, int nbConstraints) {
            this.membership = new int[nbConstraints];
            this.next = new int[nbConstraints];
            this.head = new int[nbVariables];
            this.size = new int[nbVariables];
        }

        private Variable getFirstLexicoVariableIn(Constraint constraint) {
            Variable var = null;
            Variable[] variableArray = constraint.getInvolvedVariables();
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable variable = variableArray[n];
                if (!(variable.isAssigned() || var != null && variable.getId() >= var.getId())) {
                    var = variable;
                }
                ++n;
            }
            return var;
        }

        void init() {
            Arrays.fill(this.head, -1);
            Arrays.fill(this.size, 0);
            this.pastHead = -1;
            this.nbPastConstraints = 0;
            this.nbViolatedPastConstraints = 0;
            Constraint[] constraintArray = MaxCSPOnePass.this.solver.getConstraints();
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                if (constraint.getVariableManager().areAllPastVariables()) {
                    this.membership[constraint.getId()] = -1;
                    this.next[constraint.getId()] = this.pastHead;
                    this.pastHead = constraint.getId();
                    ++this.nbPastConstraints;
                    if (!constraint.seekSupport()) {
                        ++this.nbViolatedPastConstraints;
                    }
                } else {
                    int i = constraint.getId();
                    Variable[] involvedVariables = constraint.getInvolvedVariables();
                    int positionOfBestVariable = -1;
                    double best = -1.0;
                    int j = 0;
                    while (j < involvedVariables.length) {
                        if (!involvedVariables[j].isAssigned()) {
                            double cpt = 0.0;
                            if (MaxCSPOnePass.this.revisionManager.mustBeRevised(constraint, involvedVariables[j])) {
                                Elements elements = involvedVariables[j].getDomain().getElements();
                                int index = elements.getFirstPresent();
                                while (index != -1) {
                                    boolean consistent = MaxCSPOnePass.this.supportManager.seekNextSupport(i, j, index);
                                    boolean bl = ((MaxCSPOnePass)MaxCSPOnePass.this).inconsistent[i][j][index] = !consistent;
                                    if (!consistent) {
                                        cpt += 1.0;
                                    }
                                    index = elements.getNextPresent(index);
                                }
                            } else {
                                Arrays.fill(MaxCSPOnePass.this.inconsistent[i][j], false);
                            }
                            if (best == -1.0 || cpt / (double)involvedVariables[j].getCurrentDomainSize() > best) {
                                positionOfBestVariable = j;
                                best = cpt;
                            }
                        }
                        ++j;
                    }
                    Variable bestVariable = involvedVariables[positionOfBestVariable];
                    this.membership[constraint.getId()] = bestVariable.getId();
                    this.next[constraint.getId()] = this.head[bestVariable.getId()];
                    this.head[bestVariable.getId()] = constraint.getId();
                    int n3 = bestVariable.getId();
                    this.size[n3] = this.size[n3] + 1;
                }
                ++n;
            }
            if (!$assertionsDisabled && !this.control()) {
                throw new AssertionError();
            }
        }

        int computeNbViolatedConstraintsInvolving(Variable variable, int index) {
            Constraint[] constraints = MaxCSPOnePass.this.solver.getConstraints();
            int cpt = 0;
            int current = this.head[variable.getId()];
            while (current != -1) {
                if (MaxCSPOnePass.this.inconsistent[current][constraints[current].getPositionOf(variable)][index]) {
                    ++cpt;
                }
                current = this.next[current];
            }
            return cpt;
        }

        private boolean control() {
            int i = 0;
            while (i < this.head.length) {
                int current = this.head[i];
                while (current != -1) {
                    if (this.membership[current] != i) {
                        return false;
                    }
                    current = this.next[current];
                }
                ++i;
            }
            Constraint[] constraints = MaxCSPOnePass.this.solver.getConstraints();
            int i2 = 0;
            while (i2 < this.membership.length) {
                if (this.membership[i2] == -1) {
                    if (!constraints[i2].getVariableManager().areAllPastVariables()) {
                        return false;
                    }
                } else {
                    int variableId = this.membership[i2];
                    boolean found = false;
                    int current = this.head[variableId];
                    while (!found && current != -1) {
                        if (current == i2) {
                            found = true;
                        }
                        current = this.next[current];
                    }
                    if (!found) {
                        return false;
                    }
                }
                ++i2;
            }
            return true;
        }

        private void display() {
            Variable[] variables = MaxCSPOnePass.this.solver.getVariables();
            Constraint[] constraints = MaxCSPOnePass.this.solver.getConstraints();
            int i = 0;
            while (i < this.head.length) {
                System.out.print(variables[i] + " of size " + this.size[i] + " :");
                int current = this.head[i];
                while (current != -1) {
                    System.out.print(constraints[current] + " ");
                    current = this.next[current];
                }
                System.out.println();
                ++i;
            }
        }
    }
}

