/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.cpc;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.problem.cliques.Path;
import abscon.problem.cliques.PathManager;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.cpc.PropagationSetOfValues;
import abscon.solvers.Solver;

public class PC2001
extends ArcConsistency {
    private PathManager cliqueManager;
    private PropagationSetOfValues set;
    private boolean preproAC = false;
    private int[][][][] last;
    int[] t = new int[2];

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        if (solver.mustDoSearch()) {
            throw new IncompatiblePropertiesException();
        }
        if (solver.getProblem().getMaxConstraintArity() > 2) {
            throw new IncompatiblePropertiesException();
        }
        this.cliqueManager = new PathManager(solver.getProblem());
        this.set = new PropagationSetOfValues(solver.getProblem());
        this.last = new int[solver.getNbConstraints()][][][];
        Constraint[] constraintArray = solver.getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getArity() == 2) {
                int d0 = constraint.getInvolvedVariable(0).getDomain().getMaximumSize();
                int d1 = constraint.getInvolvedVariable(1).getDomain().getMaximumSize();
                int k = this.cliqueManager.getPathes(constraint.getId()).length;
                this.last[constraint.getId()] = new int[d0][d1][k];
            }
            ++n;
        }
    }

    public void initializeBeforeRun() {
        super.initializeBeforeRun();
    }

    private boolean checkPathConsistencyOfSupport(Constraint constraint, int[] constraintSupport, int cliquePosition, int start) {
        int index = this.cliqueManager.getPathSupport(constraint, constraintSupport, cliquePosition, start, null);
        if (index == -1) {
            constraint.removeTuple(constraintSupport);
            this.set.add(constraint, constraint.getInvolvedVariable(0), constraintSupport[0]);
            this.set.add(constraint, constraint.getInvolvedVariable(1), constraintSupport[1]);
            return false;
        }
        this.last[constraint.getId()][constraintSupport[0]][constraintSupport[1]][cliquePosition] = index;
        return true;
    }

    private boolean initialize() {
        Constraint[] constraintArray = this.solver.getProblem().getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getArity() == 2) {
                Path[] cliques = this.cliqueManager.getPathes(constraint.getId());
                boolean anotherSupport = constraint.getFirstSupport(this.t);
                while (anotherSupport) {
                    int i = 0;
                    while (i < cliques.length) {
                        boolean consistent = this.checkPathConsistencyOfSupport(constraint, this.t, i, -1);
                        if (!consistent) break;
                        ++i;
                    }
                    anotherSupport = constraint.getNextSupport(this.t);
                }
            }
            ++n;
        }
        return true;
    }

    private void revisePath(Constraint constraint, Variable variable, int index) {
        Path[] cliques = this.cliqueManager.getPathes(constraint.getId());
        int i = 0;
        while (i < cliques.length) {
            Constraint edge = variable == cliques[i].variable1 ? cliques[i].edge1 : cliques[i].edge2;
            int cliquePosition = this.cliqueManager.getPositionOfPathWith(edge, constraint.getFirstVariableDifferentFrom(variable));
            int variablePosition = edge.getPositionOf(variable);
            boolean anotherSupport = edge.seekSupport(variablePosition, index, this.t);
            while (anotherSupport) {
                boolean consistent = this.checkPathConsistencyOfSupport(edge, this.t, cliquePosition, this.last[edge.getId()][this.t[0]][this.t[1]][cliquePosition]);
                anotherSupport = edge.seekAnotherSupport(variablePosition, index, this.t);
            }
            ++i;
        }
    }

    private boolean revise() {
        while (this.set.size() > 0) {
            Constraint constraint = this.set.getFirstConstraint();
            Variable variable = this.set.getFirstVariable();
            int index = this.set.getFirstIndex();
            this.set.remove(0);
            this.revisePath(constraint, variable, index);
        }
        return true;
    }

    public boolean checkConsistency() {
        this.supportManager.setRelationFiltering(true);
        Domain.resetNbRemovals();
        if (this.preproAC && !super.checkConsistency()) {
            return false;
        }
        System.out.println(" AC : " + Domain.getNbRemovals() + " values removed");
        this.initialize();
        System.out.println(" PC : " + this.solver.getStatistics().computeNbTuplesRemovals() + " tuples removed " + Domain.getNbRemovals() + " values removed");
        this.revise();
        return true;
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        throw new UnreachableCodeException();
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        throw new UnreachableCodeException();
    }
}

