/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.cpc;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.problem.cliques.Clique;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.cpc.ConservativePathConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.cpc.PropagationSetOfValues;
import abscon.solvers.Solver;

public class CPC8N
extends ConservativePathConsistency {
    protected PropagationSetOfValues set;

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        this.set = new PropagationSetOfValues(solver.getProblem());
    }

    protected boolean checkPathConsistencyOfSupport(Constraint constraint, int[] constraintSupport, Clique clique) {
        int index = this.cliqueManager.getPathSupport(constraint, constraintSupport, clique, 0, null);
        if (index == -1) {
            constraint.removeTuple(constraintSupport);
            this.set.add(constraint, constraint.getInvolvedVariable(0), constraintSupport[0]);
            this.set.add(constraint, constraint.getInvolvedVariable(1), constraintSupport[1]);
            return false;
        }
        return true;
    }

    private boolean filterConstraint(Constraint constraint) {
        Variable firstVariable = constraint.getInvolvedVariable(0);
        int firstDomainBefore = firstVariable.getCurrentDomainSize();
        Variable secondVariable = constraint.getInvolvedVariable(1);
        int secondDomainBefore = secondVariable.getCurrentDomainSize();
        boolean anotherSupport = constraint.getFirstSupport(this.buffer);
        while (anotherSupport) {
            Clique[] cliqueArray = this.cliqueManager.getCliques(constraint.getId());
            int n = 0;
            int n2 = cliqueArray.length;
            while (n < n2) {
                Clique clique = cliqueArray[n];
                if (!this.checkPathConsistencyOfSupport(constraint, this.buffer, clique)) {
                    if (!this.strong) break;
                    if (!this.supportManager.seekNextSupport(constraint.getId(), 0, this.buffer[0])) {
                        firstVariable.getDomain().removeElementAt(this.buffer[0]);
                        if (firstVariable.getCurrentDomainSize() == 0) {
                            return false;
                        }
                    }
                    if (this.supportManager.seekNextSupport(constraint.getId(), 1, this.buffer[1])) break;
                    secondVariable.getDomain().removeElementAt(this.buffer[1]);
                    if (secondVariable.getCurrentDomainSize() != 0) break;
                    return false;
                }
                ++n;
            }
            anotherSupport = constraint.getNextSupport(this.buffer);
        }
        if (this.strong) {
            assert (this.propagationSet.controlClear());
            if (firstDomainBefore != firstVariable.getCurrentDomainSize()) {
                this.propagationSet.initAfterModificationOf(firstVariable);
            }
            if (secondDomainBefore != secondVariable.getCurrentDomainSize()) {
                this.propagationSet.initAfterModificationOf(secondVariable);
            }
            return this.checkConsistencyOfPropagationSet();
        }
        return true;
    }

    protected boolean initialize() {
        Constraint[] constraintArray = this.solver.getProblem().getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getArity() == 2 && !this.filterConstraint(constraint)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void revisePath(Constraint constraint, Variable variable, int index) {
        Clique[] cliques = this.cliqueManager.getCliques(constraint.getId());
        int i = 0;
        while (i < cliques.length) {
            Constraint edge = cliques[i].getEdgeConstraint(constraint, variable);
            int variablePosition = edge.getPositionOf(variable);
            boolean anotherSupport = edge.seekSupport(variablePosition, index, this.buffer);
            while (anotherSupport) {
                boolean consistent = this.checkPathConsistencyOfSupport(edge, this.buffer, cliques[i]);
                anotherSupport = edge.seekAnotherSupport(variablePosition, index, this.buffer);
            }
            ++i;
        }
    }

    private boolean revise() {
        while (this.set.size() > 0) {
            Constraint constraint = this.set.getFirstConstraint();
            Variable variable = this.set.getFirstVariable();
            int index = this.set.getFirstIndex();
            this.set.remove(0);
            this.revisePath(constraint, variable, index);
        }
        return true;
    }

    public boolean checkPathConsistency() {
        if (!this.initialize()) {
            return false;
        }
        System.out.println(" PC : " + this.solver.getStatistics().computeNbTuplesRemovals() + " tuples removed " + Domain.getNbRemovals() + " values removed");
        this.revise();
        System.out.println(" PC : " + this.solver.getStatistics().computeNbTuplesRemovals() + " tuples removed " + Domain.getNbRemovals() + " values removed");
        return true;
    }
}

