/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ArcConsistency;
import abscon.propagationTechniques.propagationSets.PropagationSetOfVariables;
import abscon.solvers.Solver;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;

public class MaxRPC
extends ArcConsistency {
    private PropagationSetOfVariables queue;
    private int variant;
    private boolean mustMaintainAC = true;
    private int[] sizes;

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        if (((SystematicSolver)solver).getBacktrackingMode() != 10) {
            throw new IncompatiblePropertiesException();
        }
        this.queue = new PropagationSetOfVariables();
        this.queue.attachTo(this);
        this.variant = ConfigurationManager.getInt(this.getLevel(), String.valueOf(this.getPhase()) + "/" + "propagationTechnique", "variant");
        if (this.mustMaintainAC) {
            this.sizes = new int[solver.getNbVariables()];
        }
    }

    private int reviseMaxRPC(Constraint constraint, Variable variable) {
        this.pathExtension = true;
        Domain domain = variable.getDomain();
        int variablePosition = constraint.getPositionOf(variable);
        int domainSize = domain.getCurrentSize();
        Elements elements = domain.getElements();
        if (this.boundConsistency) {
            while (elements.getNbPresentElements() > 0 && !this.supportManager.seekNextSupport(constraint.getId(), variablePosition, elements.getFirstPresent())) {
                domain.removeElementAt(elements.getFirstPresent());
            }
            while (elements.getNbPresentElements() > 1 && !this.supportManager.seekNextSupport(constraint.getId(), variablePosition, elements.getLastPresent())) {
                domain.removeElementAt(elements.getLastPresent());
            }
        } else {
            int index = elements.getFirstPresent();
            while (index != -1) {
                int nextIndex = elements.getNextPresent(index);
                if (!this.supportManager.seekNextSupport(constraint.getId(), variablePosition, index)) {
                    domain.removeElementAt(index);
                }
                index = nextIndex;
            }
        }
        return domainSize - domain.getCurrentSize();
    }

    protected boolean reestablishAC(Variable variable) {
        this.pathExtension = false;
        Variable[] variables = this.solver.getVariables();
        int i = 0;
        while (i < this.sizes.length) {
            this.sizes[i] = variables[i].getCurrentDomainSize();
            ++i;
        }
        this.propagationSet.initAfterModificationOf(variable);
        boolean consistent = this.checkConsistencyOfPropagationSet();
        if (!consistent) {
            this.queue.clear();
            return false;
        }
        int i2 = 0;
        while (i2 < this.sizes.length) {
            if (this.sizes[i2] - variables[i2].getCurrentDomainSize() > 0) {
                this.queue.addNeighboursOf(variables[i2]);
                if (this.boundConsistency) {
                    this.queue.add(variables[i2]);
                }
            }
            ++i2;
        }
        return true;
    }

    public boolean checkConsistencyOf(Variable variable) {
        assert (!variable.isAssigned());
        boolean modified = false;
        Constraint[] constraints = variable.getInvolvingConstraints();
        int i = 0;
        while (i < constraints.length) {
            ++this.nbRevisions;
            int nbRemovals = this.reviseMaxRPC(constraints[i], variable);
            if (nbRemovals == 0) {
                ++this.nbUselessRevisions;
            } else {
                if (variable.getCurrentDomainSize() == 0) {
                    this.queue.clear();
                    this.culprit = variable;
                    return false;
                }
                modified = true;
                if (this.mustMaintainAC && !this.reestablishAC(variable)) {
                    return false;
                }
            }
            ++i;
        }
        if (modified) {
            this.queue.addNeighboursOf(variable);
            if (this.boundConsistency) {
                this.queue.add(variable);
            }
        }
        return true;
    }

    public boolean extraPropagation() {
        if (this.variant == 1) {
            return true;
        }
        this.queue.fillWithPastVariables();
        while (this.queue.size() > 0) {
            Variable variable = this.queue.getFirstVariable();
            this.queue.removeFirstElement();
            if (this.checkConsistencyOf(variable)) continue;
            return false;
        }
        assert (this.controlConsistency(true));
        return true;
    }

    public boolean checkConsistency() {
        boolean bl = this.pathExtension = this.variant != 2;
        return super.checkConsistency() && this.extraPropagation();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        boolean bl = this.pathExtension = this.variant != 2;
        return super.checkConsistencyAfterAssignmentOf(variable) && this.extraPropagation();
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        boolean bl = this.pathExtension = this.variant != 2;
        return super.checkConsistencyAfterRefutationOf(variable, variableDepth) && this.extraPropagation();
    }
}

