/*
 * Decompiled with CFR 0.152.
 */
package abscon.problem.domains;

import abscon.constraints.Constraint;
import abscon.problem.Explanations;
import abscon.problem.Variable;
import abscon.solvers.Solver;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.IEvaluator;
import abscon.tools.elements.Elements;

public abstract class Domain {
    public static final String SEPARATOR = " ";
    public static final String DISCRETE_INTERVAL_SEPARATOR = "..";
    public static final String DISCRETE_INTERVAL_START = "";
    public static final String DISCRETE_INTERVAL_END = "";
    private static int nbRemovals;
    protected Variable variable;
    protected String domainTypeName;
    protected Elements elements;
    protected Explanations explanations;
    protected boolean indexValueSimilarity;
    private double[] weights;
    protected Object[] objectValues;
    protected int uniqueIndex = -10;
    private int maximumSize;

    public static void resetNbRemovals() {
        nbRemovals = 0;
    }

    public static int getNbRemovals() {
        return nbRemovals;
    }

    public static void incrementNbRemovals() {
        ++nbRemovals;
    }

    public double getWeightOf(int index) {
        return this.weights[index];
    }

    public void incrementWeightOf(int index) {
        if (this.weights != null) {
            int n = index;
            this.weights[n] = this.weights[n] + 1.0;
        }
    }

    public Variable getVariable() {
        return this.variable;
    }

    public int getId() {
        return this.variable.getId();
    }

    public String getDomainTypeName() {
        return this.domainTypeName;
    }

    public void setDomainTypeName(String domainTypeName) {
        this.domainTypeName = domainTypeName;
    }

    public Elements getElements() {
        return this.elements;
    }

    public Explanations getExplanations() {
        return this.explanations;
    }

    public boolean getIndexValueSimilarity() {
        return this.indexValueSimilarity;
    }

    public Object getObjectValue(int i) {
        return this.objectValues[i];
    }

    public void setObjectValues(Object[] objectValues) {
        this.objectValues = objectValues;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public int getCurrentSize() {
        return this.elements.getNbPresentElements();
    }

    public int getNbLostElements() {
        return this.elements.getNbAbsentElements();
    }

    public boolean isEmpty() {
        return this.elements.getNbPresentElements() == 0;
    }

    public int getFirstValidIndex() {
        return this.elements.getFirstPresent();
    }

    public int getRandomIndex() {
        if (this.uniqueIndex != -10) {
            return this.uniqueIndex;
        }
        return this.elements.getRandomElement(this.variable.getProblem().getResolution().getRandom());
    }

    public int getLastValidIndex() {
        return this.elements.getLastPresent();
    }

    public int getNextValidIndexAfter(int index) {
        return this.elements.getNextPresent(index);
    }

    public void setUniqueIndex(int uniqueIndex) {
        this.uniqueIndex = uniqueIndex;
    }

    public double getImpactAtCurrentDepth() {
        int currentDepth = this.variable.getProblem().getSolver().getCurrentDepth();
        double nb = this.elements.getNbAbsentElementsAtDepth(currentDepth);
        return (double)this.getCurrentSize() / (nb + (double)this.getCurrentSize());
    }

    public Domain(Variable variable, int size) {
        this.variable = variable;
        this.maximumSize = size;
        if (variable.getProblem().getResolution() != null && !variable.getProblem().getResolution().isCompetition()) {
            this.weights = new double[size];
        }
    }

    private boolean determineIndexValueSimilarity() {
        int index = this.elements.getFirstPresent();
        while (index != -1) {
            int value = this.toValue(index);
            if (value != index) {
                return false;
            }
            assert (index == this.toIndex(value));
            index = this.elements.getNextPresent(index);
        }
        return true;
    }

    public void fix() {
        this.elements.initialize();
        Solver solver = this.variable.getProblem().getSolver();
        if (solver instanceof SystematicSolver && ((SystematicSolver)solver).getBacktrackingMode() != 10) {
            this.explanations = new Explanations(this);
        }
        this.indexValueSimilarity = this.determineIndexValueSimilarity();
    }

    public abstract int toIndex(int var1);

    public abstract int toValue(int var1);

    public int getUniqueIndex() {
        if (this.uniqueIndex == -10) {
            return this.elements.getUniquePresentElement();
        }
        return this.uniqueIndex;
    }

    public int getUniqueValue() {
        return this.toValue(this.getUniqueIndex());
    }

    public boolean hasIndex(int index) {
        return this.elements.isPresent(index);
    }

    public boolean hasValue(int value) {
        return this.elements.isPresent(this.toIndex(value));
    }

    public boolean isThereAtLeastARemovalAtCurrentDepth() {
        int depth = this.elements.getLastAbsentLevel();
        return depth == -1 ? false : depth == this.variable.getProblem().getSolver().getCurrentDepth();
    }

    public int getFirstValidIndexStrictlyGreaterThan(int index) {
        return this.elements.getNextPresent(index);
    }

    public void removeElementAt(int index, Variable[] culpritVariables, int nbCulpritVariables) {
        assert (!this.variable.isAssigned()) : "The variable " + this.variable + " is assigned to " + this.variable.getDomain().getFirstValidIndex();
        if (this.explanations != null) {
            this.explanations.setExplanationOf(index, culpritVariables, nbCulpritVariables);
        }
        this.elements.remove(index, this.variable.getProblem().getSolver().getCurrentDepth());
        ++nbRemovals;
    }

    public void removeElementAt(int index, Variable[] culpritVariables, int nbCulpritVariables, int level) {
        assert (!this.variable.isAssigned()) : "The variable " + this.variable + " is assigned";
        this.elements.remove(index, level);
        ++nbRemovals;
    }

    public void removeElementAt(int index, Variable[] culprits) {
        this.removeElementAt(index, culprits, culprits.length);
    }

    public void removeElementAt(int index) {
        this.removeElementAt(index, null, 0);
    }

    public void removeElementAt(int index, Constraint culpritConstraint) {
        this.removeElementAt(index, culpritConstraint.getInvolvedVariables(), culpritConstraint.getNbInvolvedVariables());
    }

    public void removeDefinitivelyElementAt(int index) {
        assert (!this.variable.isAssigned()) : "The variable " + this.variable + " is assigned";
        Solver solver = this.variable.getProblem().getSolver();
        if (this.variable.getProblem().getConstraints() == null) {
            assert (this.explanations == null);
            this.elements.remove(index, 0);
        } else {
            if (this.explanations != null) {
                this.explanations.setDefinitiveExplanationOf(index);
            }
            this.elements.remove(index, solver.getCurrentDepth());
            ++nbRemovals;
        }
    }

    public void addElementAt(int index) {
        assert (this.variable.isFuture());
        this.elements.add(index);
    }

    public void removeDefinitivelyIntervalFromValue(int v) {
        int index = this.elements.getLastPresent();
        while (index != -1) {
            if (this.toValue(index) < v) break;
            this.removeDefinitivelyElementAt(index);
            index = this.elements.getPrevPresent(index);
        }
    }

    public void removeDefinitivelyIntervalUpToValue(int v) {
        int index = this.elements.getFirstPresent();
        while (index != -1) {
            if (this.toValue(index) > v) break;
            this.removeDefinitivelyElementAt(index);
            index = this.elements.getNextPresent(index);
        }
    }

    public void removeIntervalUpToValue(int v, IEvaluator evaluator, Variable[] culprits) {
        int index = this.elements.getFirstPresent();
        while (index != -1) {
            int value = evaluator.evaluate(this.variable, index);
            if (value > v) break;
            this.removeElementAt(index, culprits);
            index = this.elements.getNextPresent(index);
        }
    }

    public int reduceToElementAt(int index) {
        assert (!this.variable.isAssigned() && this.hasIndex(index)) : this.variable + " has lost " + index;
        int size = this.elements.getNbPresentElements();
        int depth = this.variable.getProblem().getSolver().getCurrentDepth();
        if (this.explanations != null) {
            int i = this.elements.getFirstPresent();
            while (i != -1) {
                if (i != index) {
                    this.elements.remove(i, depth);
                    this.explanations.setAutoExplanationOf(i);
                }
                i = this.elements.getNextPresent(i);
            }
        } else {
            this.elements.reduceTo(index, depth);
        }
        assert (this.elements.getNbPresentElements() == 1);
        return size - 1;
    }

    public void restoreElementsRemovedAtLevelGreaterThanOrEqualTo(int depth) {
        this.elements.restoreElementsAtLevelGreaterThanOrEqualTo(depth);
    }

    public String getStringListOfValues() {
        if (this.elements.getNbPresentElements() == 0) {
            return "";
        }
        int index = this.elements.getFirstPresent();
        int previousValue = this.toValue(index);
        boolean startedInterval = false;
        StringBuffer sb = new StringBuffer();
        index = this.elements.getNextPresent(index);
        while (index != -1) {
            int currentValue = this.toValue(index);
            if (currentValue != previousValue + 1) {
                if (startedInterval) {
                    sb.append(String.valueOf(previousValue));
                    startedInterval = false;
                } else {
                    sb.append(previousValue);
                }
                sb.append(SEPARATOR);
            } else if (!startedInterval) {
                sb.append(previousValue + DISCRETE_INTERVAL_SEPARATOR);
                startedInterval = true;
            }
            previousValue = currentValue;
            index = this.elements.getNextPresent(index);
        }
        if (startedInterval) {
            sb.append(String.valueOf(previousValue));
        } else {
            sb.append(previousValue);
        }
        return sb.toString();
    }

    public String toString() {
        return "dom(" + this.variable.getName() + ")";
    }

    public void display() {
        System.out.println("  Domain " + this + " (ivs = " + this.indexValueSimilarity + ")");
        System.out.println("\t initialSize = " + this.elements.getInitialSize() + " and currentSize = " + this.elements.getNbPresentElements());
        System.out.println("\t first index = " + this.elements.getFirstPresent() + " and last index = " + this.elements.getLastPresent());
        if (this.elements.getNbPresentElements() != 0) {
            System.out.println("\t first value = " + this.toValue(this.elements.getFirstPresent()) + " and last value = " + this.toValue(this.elements.getLastPresent()));
        }
    }

    public void displayExhaustively() {
        this.display();
        System.out.println("\t values = {" + this.getStringListOfValues() + "}");
        System.out.println("Elements\n" + this.elements);
    }

    public boolean controlExplanations() {
        if (this.explanations != null) {
            return this.explanations.controlAllExplanations();
        }
        return true;
    }
}

