/*
 * Decompiled with CFR 0.152.
 */
package abscon.problem;

import abscon.constraints.Constraint;
import abscon.heuristics.valueOrdering.ValueOrderingHeuristic;
import abscon.problem.Problem;
import abscon.problem.domains.BoundDomain;
import abscon.problem.domains.Domain;
import abscon.problem.domains.MultipleDomain;
import abscon.problem.domains.SimpleDomain;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.reflection.Factory;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable
implements Comparable<Variable> {
    public static Variable TAG = new Variable(){};
    private Problem problem;
    private String name;
    private int id;
    protected Domain domain;
    private boolean assigned;
    private boolean disconnected;
    protected Constraint[] involvingConstraints;
    private Variable[] neighbours;
    private ValueOrderingHeuristic valueOrderingHeuristic;
    private static long globalCounter;
    private long counter;
    private long weightedDegree;
    private double weight;
    private Collection<Constraint> collectedConstraints = new LinkedList<Constraint>();

    public static final long getGlobalCounter() {
        return globalCounter;
    }

    public static final long incrementGlobalCounter() {
        return ++globalCounter;
    }

    public final long getCounter() {
        return this.counter;
    }

    public final void incrementCounter() {
        this.counter = ++globalCounter;
    }

    public long getWeightedDegree() {
        return this.weightedDegree;
    }

    public void setWeightedDegree(long weightedDegree) {
        this.weightedDegree = weightedDegree;
    }

    public void resetWeightedDegree() {
        this.weightedDegree = this.involvingConstraints.length;
    }

    public void incrementWeightedDegree() {
        ++this.weightedDegree;
    }

    public void incrementWeightedDegreeOf(long increment) {
        this.weightedDegree += increment;
    }

    public long computeWeightedDegree() {
        long cpt = 0L;
        int i = 0;
        while (i < this.involvingConstraints.length) {
            if (this.involvingConstraints[i].getNbFutureVariables() >= 2) {
                cpt += this.involvingConstraints[i].getWeightedDegree();
            }
            ++i;
        }
        return cpt;
    }

    public double getWeightedDegreeOnDomainSize() {
        return (double)this.weightedDegree / (double)this.domain.getCurrentSize();
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    public double getWeight() {
        return this.weight;
    }

    private Variable() {
        this.id = -1;
    }

    public Variable(Problem problem, String name, int inf, int sup) {
        this.problem = problem;
        this.name = name;
        boolean boundConsistency = ConfigurationManager.getBoolean(problem.getLevelInResolution(), "preprocessing/propagationTechnique", "boundConsistency");
        this.domain = boundConsistency ? new BoundDomain(this, inf, sup) : new SimpleDomain(this, inf, sup);
    }

    public Variable(Problem problem, int inf, int sup) {
        this(problem, null, inf, sup);
    }

    public Variable(Problem problem, String name, int[] values) {
        this.problem = problem;
        this.name = name;
        this.domain = new MultipleDomain(this, (int[])values.clone());
    }

    public Variable(Problem problem, int[] values) {
        this(problem, null, values);
    }

    public Problem getProblem() {
        return this.problem;
    }

    public int getId() {
        return this.id;
    }

    public String getDefaultName() {
        return "V" + this.problem.getQuotes() + this.id;
    }

    public String getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public String getName(boolean defaultName) {
        if (defaultName || this.name == null) {
            return this.getDefaultName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final Domain getDomain() {
        return this.domain;
    }

    public final int getCurrentDomainSize() {
        return this.domain.getCurrentSize();
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void setDisconnected(boolean disconnection) {
        this.disconnected = disconnection;
        int i = 0;
        while (i < this.involvingConstraints.length) {
            this.involvingConstraints[i].getVariableManager().updateNbDisconnectedVariables(disconnection);
            ++i;
        }
    }

    public final boolean isFuture() {
        return !this.assigned && !this.disconnected;
    }

    public ValueOrderingHeuristic getValueOrderingHeuristic() {
        return this.valueOrderingHeuristic;
    }

    public int getNbInvolvingConstraints() {
        return this.involvingConstraints.length;
    }

    public Constraint[] getInvolvingConstraints() {
        return this.involvingConstraints;
    }

    public Constraint getInvolvingConstraint(int i) {
        return this.involvingConstraints[i];
    }

    public Variable[] getNeighbours() {
        return this.neighbours;
    }

    public void setId(int i) {
        this.id = i;
    }

    private void setValueOrderingHeuristic(String className) {
        this.valueOrderingHeuristic = (ValueOrderingHeuristic)Factory.getInstanceOf(className, ValueOrderingHeuristic.class);
        this.valueOrderingHeuristic.attachTo(this);
    }

    public void setValueOrderingHeuristic() {
        String className = ConfigurationManager.getString(this.problem.getLevelInResolution(), "search/valueHeuristic", "class");
        this.setValueOrderingHeuristic(className);
    }

    @Override
    public int compareTo(Variable variable) {
        return this.id - variable.id;
    }

    public void updateConstraintDomainManagers(int nbRemovals) {
        int i = 0;
        while (i < this.involvingConstraints.length) {
            this.involvingConstraints[i].getDomainManager().setNbRecentDomainRemovals(this, nbRemovals);
            ++i;
        }
    }

    public boolean isNeighbourOf(Variable variable) {
        if (this.neighbours != null) {
            return Arrays.binarySearch(this.neighbours, variable) >= 0;
        }
        if (this.involvingConstraints.length <= variable.getNbInvolvingConstraints()) {
            Constraint[] constraintArray = this.involvingConstraints;
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                if (constraint.isBinding(variable)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return variable.isNeighbourOf(this);
    }

    public int computeNbConflictsFor(int index) {
        assert (!this.assigned && this.domain.hasIndex(index));
        int cpt = 0;
        Constraint[] constraintArray = this.involvingConstraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            cpt += constraint.computeNbTuplesFor(constraint.getPositionOf(this), index, false);
            ++n;
        }
        return cpt;
    }

    public int computeNbSupportsFor(int index) {
        int cpt = 0;
        Constraint[] constraintArray = this.involvingConstraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            cpt += constraint.computeNbTuplesFor(constraint.getPositionOf(this), index, true);
            ++n;
        }
        return cpt;
    }

    public Constraint getBinaryConstraintWith(Variable variable) {
        assert (this != variable);
        Constraint[] constraintArray = this.involvingConstraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getArity() == 2 && constraint.isBinding(variable)) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    public Constraint getNonBinaryConstraintWith(Variable variable) {
        assert (this != variable);
        Constraint[] constraintArray = this.involvingConstraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getArity() > 2 && constraint.isBinding(variable)) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    public void addInvolvingConstraint(Constraint constraint) {
        this.collectedConstraints.add(constraint);
    }

    public void removeInvolvingConstraint(Constraint constraint) {
        this.collectedConstraints.remove(constraint);
    }

    public Collection<Constraint> getCollectedConstraints() {
        return this.collectedConstraints;
    }

    private Variable[] computeNeighbours() {
        TreeSet<Variable> set = new TreeSet<Variable>();
        Constraint[] constraintArray = this.involvingConstraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            Variable[] variableArray = constraint.getInvolvedVariables();
            int n3 = 0;
            int n4 = variableArray.length;
            while (n3 < n4) {
                Variable variable = variableArray[n3];
                if (variable != this) {
                    set.add(variable);
                }
                ++n3;
            }
            ++n;
        }
        return set.toArray(new Variable[set.size()]);
    }

    private void fixNeighbours() {
        if (this.problem.getNbVariables() > 5000) {
            return;
        }
        this.neighbours = this.computeNeighbours();
        if (this.neighbours.length > this.problem.getNbVariables() / 2 || this.neighbours.length > 100) {
            this.neighbours = null;
        }
    }

    void fixInvolvingConstraints() {
        this.involvingConstraints = this.collectedConstraints.toArray(new Constraint[0]);
        this.weight = this.involvingConstraints.length;
        this.resetWeightedDegree();
        this.fixNeighbours();
    }

    public void doAssignment(int index) {
        assert (!this.assigned);
        this.domain.reduceToElementAt(index);
        this.assigned = true;
        Constraint[] constraintArray = this.involvingConstraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            constraint.getVariableManager().doAPastVariableOf(this);
            if (constraint.getNbFutureVariables() == 1) {
                constraint.getFirstFutureVariable().incrementWeightedDegreeOf(-constraint.getWeightedDegree());
            }
            ++n;
        }
    }

    public void undoAssignment() {
        Constraint[] constraintArray = this.involvingConstraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getNbFutureVariables() == 1) {
                constraint.getFirstFutureVariable().incrementWeightedDegreeOf(constraint.getWeightedDegree());
            }
            constraint.getVariableManager().undoAPastVariableOf(this);
            ++n;
        }
        this.assigned = false;
    }

    public boolean checkBackwardConsistencyOf(int index) {
        assert (!this.isAssigned());
        Constraint[] constraintArray = this.involvingConstraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getNbFutureVariables() == 1 && constraint.seekSupport(constraint.getPositionOf(this), index)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getDegree() {
        return this.involvingConstraints.length;
    }

    public int getDynamicDegree() {
        int cpt = 0;
        int i = 0;
        while (i < this.involvingConstraints.length) {
            if (this.involvingConstraints[i].getNbFutureVariables() >= 2) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public Constraint getUniqueFreeConstraint() {
        Constraint constraint = null;
        int nb = this.domain.getCurrentSize() == 1 ? 0 : 1;
        int i = 0;
        while (i < this.involvingConstraints.length) {
            if (this.involvingConstraints[i].getNbFreeVariables() > nb) {
                if (constraint != null) {
                    return null;
                }
                constraint = this.involvingConstraints[i];
            }
            ++i;
        }
        return constraint == null ? Constraint.TAG : constraint;
    }

    public int getNbLinkedFutureVariables() {
        int cpt = 0;
        int i = 0;
        while (i < this.involvingConstraints.length) {
            cpt += this.involvingConstraints[i].getNbFutureVariables() - 1;
            ++i;
        }
        return cpt;
    }

    public String getStringListOfConstraints() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.involvingConstraints.length) {
            sb.append(String.valueOf(i > 0 ? " " : "") + this.involvingConstraints[i]);
            ++i;
        }
        return sb.toString();
    }

    public String getStringListOfNeighbours() {
        StringBuffer sb = new StringBuffer();
        Variable[] vars = this.neighbours != null ? this.neighbours : this.computeNeighbours();
        int i = 0;
        while (i < vars.length) {
            sb.append(String.valueOf(i > 0 ? " " : "") + vars[i]);
            ++i;
        }
        return sb.toString();
    }

    public void display() {
        System.out.println();
        System.out.println("Variable " + this + " of degree " + this.involvingConstraints.length + " with " + this.domain.getCurrentSize() + " values and domain Type Name " + this.domain.getDomainTypeName());
    }

    public void displayExhaustively() {
        this.display();
        this.domain.displayExhaustively();
        System.out.println("  Constraints = {" + this.getStringListOfConstraints() + "}");
        System.out.println("  Neighbours = {" + this.getStringListOfNeighbours() + "}");
    }

    public String toString() {
        return this.getName();
    }

    /* synthetic */ Variable(Variable variable) {
        this();
    }
}

