/*
 * Decompiled with CFR 0.152.
 */
package abscon.problem;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetryManager {
    List<List<Variable>> equivalences;
    Variable[][] classes;
    RelationGroup[][] profiles;
    public static final int CLIQUE = 100;
    public static final int CYCLE = 101;
    public static final int SINGL = 102;

    private void newElement(List<RelationGroup> list, Variable variable, String relationTypeName, int position, Constraint constraint) {
        int cpt = 0;
        for (RelationGroup group : list) {
            if (group.relationTypeName.compareTo(relationTypeName) < 0) {
                ++cpt;
                continue;
            }
            if (group.relationTypeName.compareTo(relationTypeName) > 0) break;
            assert (group.relationTypeName.equals(relationTypeName));
            if (group.position < position) {
                ++cpt;
                continue;
            }
            if (group.position > position) break;
            group.increment(constraint);
            return;
        }
        list.add(cpt, new RelationGroup(variable, relationTypeName, position, constraint));
    }

    private RelationGroup[] manage(Variable variable) {
        LinkedList<RelationGroup> list = new LinkedList<RelationGroup>();
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            String relationTypeName = constraint.getRelationTypeName();
            int position = constraint.isSymmetric() == 1 ? 0 : constraint.getPositionOf(variable);
            this.newElement(list, variable, relationTypeName, position, constraint);
            ++n;
        }
        return list.toArray(new RelationGroup[list.size()]);
    }

    private boolean areSimilar(RelationGroup[] groups1, RelationGroup[] groups2) {
        if (groups1.length != groups2.length) {
            return false;
        }
        int i = 0;
        while (i < groups1.length) {
            if (!groups1[i].isSimilarTo(groups2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isCliqueOfSimilarAndSymmetricBinaryRelations(Variable[] equivalence) {
        Constraint constraint = equivalence[0].getBinaryConstraintWith(equivalence[1]);
        if (constraint == null || constraint.isSymmetric() != 1) {
            return false;
        }
        String relationTypeName = constraint.getRelationTypeName();
        assert (relationTypeName != null);
        int i = 0;
        while (i < equivalence.length - 1) {
            int j = i + 1;
            while (j < equivalence.length) {
                constraint = equivalence[i].getBinaryConstraintWith(equivalence[j]);
                if (constraint == null || !constraint.getRelationTypeName().equals(relationTypeName)) {
                    return false;
                }
                if (equivalence[i].getNonBinaryConstraintWith(equivalence[j]) != null) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean canBeOrdered(Variable[] equivalence, boolean clique) {
        int i = 0;
        while (i < this.profiles[equivalence[0].getId()].length) {
            RelationGroup group = this.profiles[equivalence[0].getId()][i];
            int j = 1;
            while (j < equivalence.length) {
                if (!group.isVerySimilarTo(this.profiles[equivalence[j].getId()][i], (Variable[])(clique ? equivalence : null))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private List<Variable> searchEquivalenceClass(List<List<Variable>> currentEquivalences, Variable variable) {
        for (List<Variable> list : currentEquivalences) {
            Variable representant = list.get(0);
            if (!this.areSimilar(this.profiles[variable.getId()], this.profiles[representant.getId()])) continue;
            return list;
        }
        return null;
    }

    public boolean canBeExploited(Variable[] classe) {
        return this.isCliqueOfSimilarAndSymmetricBinaryRelations(classe) & this.canBeOrdered(classe, true);
    }

    /*
     * WARNING - void declaration
     */
    public Variable[][] manage(Variable[] variables, Constraint[] constraints) {
        this.profiles = new RelationGroup[variables.length][];
        Variable[] variableArray = variables;
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            this.profiles[variable.getId()] = this.manage(variable);
            ++n;
        }
        int nbEffectiveClasses = 0;
        ArrayList<List<Variable>> equivalences = new ArrayList<List<Variable>>();
        int i = 0;
        while (i < variables.length) {
            void var6_7;
            List<Variable> list = this.searchEquivalenceClass(equivalences, variables[i]);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                equivalences.add(arrayList);
            }
            var6_7.add(variables[i]);
            if (var6_7.size() == 2) {
                ++nbEffectiveClasses;
            }
            ++i;
        }
        this.classes = new Variable[nbEffectiveClasses][];
        int cpt = 0;
        for (List list : equivalences) {
            if (list.size() < 2) continue;
            this.classes[cpt++] = list.toArray(new Variable[list.size()]);
        }
        return this.classes;
    }

    class RelationGroup {
        Variable variable;
        String relationTypeName;
        int position;
        List<Constraint> constraints;
        boolean symmetric;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !RelationGroup.class.desiredAssertionStatus();
        }

        RelationGroup(Variable variable, String relationTypeName, int position, Constraint constraint) {
            this.variable = variable;
            this.relationTypeName = relationTypeName;
            this.position = position;
            this.constraints = new LinkedList<Constraint>();
            this.constraints.add(constraint);
            this.symmetric = constraint.isSymmetric() == 1;
        }

        boolean isSimilarTo(RelationGroup group) {
            return this.relationTypeName.equals(group.relationTypeName) && this.position == group.position && this.constraints.size() == group.constraints.size();
        }

        private boolean isVerySimilarTo(Constraint constraint, Constraint otherConstraint, RelationGroup group) {
            Variable[] involvedVariables = constraint.getInvolvedVariables();
            if (this.symmetric) {
                int i = 0;
                while (i < involvedVariables.length) {
                    if (involvedVariables[i] != this.variable) {
                        if (involvedVariables[i] == group.variable) {
                            return false;
                        }
                        if (!otherConstraint.isBinding(involvedVariables[i])) {
                            return false;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < involvedVariables.length) {
                    if (involvedVariables[i] != this.variable && involvedVariables[i] != otherConstraint.getInvolvedVariable(i)) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        private boolean isVerySimilarTo(Constraint constraint, RelationGroup group) {
            for (Constraint otherConstraint : group.constraints) {
                if (!this.isVerySimilarTo(constraint, otherConstraint, group)) continue;
                return true;
            }
            return false;
        }

        private boolean isBinaryConstraintOfTheClique(Constraint constraint, Variable[] clique) {
            if (constraint.getArity() != 2 || clique == null) {
                return false;
            }
            Variable brotherVariable = constraint.getFirstVariableDifferentFrom(this.variable);
            return Arrays.binarySearch(clique, brotherVariable) >= 0;
        }

        boolean isVerySimilarTo(RelationGroup group, Variable[] clique) {
            if (!this.isSimilarTo(group)) {
                return false;
            }
            for (Constraint constraint : this.constraints) {
                if (this.isBinaryConstraintOfTheClique(constraint, clique) || this.isVerySimilarTo(constraint, group)) continue;
                return false;
            }
            return true;
        }

        void increment(Constraint constraint) {
            this.constraints.add(constraint);
            if (!$assertionsDisabled && constraint.isSymmetric() == 1 != this.symmetric) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && constraint.getPositionOf(this.variable) == -1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !constraint.getRelationTypeName().equals(this.relationTypeName)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this.symmetric && constraint.getPositionOf(this.variable) != this.position) {
                throw new AssertionError();
            }
        }

        void display() {
            System.out.println("  group (" + this.relationTypeName + "," + this.position + ") => " + this.constraints.size());
        }
    }
}

