/*
 * Decompiled with CFR 0.152.
 */
package abscon.problem;

import XSax.Problem0;
import abscon.Resolution;
import abscon.constants.AbsconConstants;
import abscon.constants.Expr;
import abscon.constraints.Constraint;
import abscon.constraints.binary.TrivialConstraint;
import abscon.constraints.global.AllDifferent;
import abscon.constraints.global.GlobalConstraint;
import abscon.constraints.universal.UniversalConstraint;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.SymmetryManager;
import abscon.problem.Variable;
import abscon.problem.cliques.Path;
import abscon.problem.cliques.PathManager;
import abscon.solvers.Solver;
import abscon.tools.IParameters;
import abscon.tools.Stopwatch;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ArgumentsManager;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.reflection.Reflector;
import abscon.xml.ProblemDocumentBuilder;
import abscon.xml.XMLManipulation;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Problem {
    protected Resolution resolution;
    protected int levelInResolution;
    protected int instanceNumber;
    protected Variable[] variables;
    protected Constraint[] constraints;
    protected Constraint[] constraintsTriggeredUponBacktracking;
    protected int[] forcedSolution;
    protected IParameters parameters;
    protected PathManager cliqueManager;
    protected int minVariableDegree = Integer.MAX_VALUE;
    protected int maxVariableDegree;
    protected int minVariableDomainSize = Integer.MAX_VALUE;
    protected int maxVariableDomainSize;
    protected int maxConstraintArity;
    protected long maxConstraintDomainSize;
    protected int nbRelationTypes;
    protected AbsconConstants.MinMaxNo optimization;
    protected boolean mergeConstraints;
    protected int nbUnaryConstraints;
    protected int nbGlobalConstraints;
    protected int nbMergedConstraints;
    protected int nbUniversalConstraints;
    protected int nbDisconnectedVariables;
    protected int nbSingletonDomainVariables;
    private long nbConstraintChecks;
    private long nbValidityChecks;
    protected double currentBestSolution = Double.MAX_VALUE;
    protected double limitBestSolution;
    private boolean containsGlobalConstraints;
    private Collection<Variable> collectedVariables = new LinkedList<Variable>();
    private Collection<Constraint> collectedConstraints = new LinkedList<Constraint>();
    private Collection<Constraint> collectedConstraintsTriggeredUponBacktracking = new LinkedList<Constraint>();
    private long durationToBeBuilt;
    public static final long SIZE_LIMIT = 10000000L;
    public static final long NB_VALUES_LIMIT = 50000L;
    private Solver solver;
    private int nbDomainTypes;
    private int nbConvertedConstraints;
    private int nbConvertConstraintsChecks;
    private int nbExtensionStructures;
    private int nbSharedExtensionStructures;
    private int nbConflictsStructures;
    private int nbUnbuiltConflictsStructures;
    private int nbSharedConflictsStructures;
    private int nbEvaluationManagers;
    private int nbSharedEvaluationManagers;
    private int nbSharedBinaryRepresentations;
    private boolean buildPrecliques = false;
    private boolean manageSymmetries = false;
    private boolean shareSupportsOfBits;

    public Constraint[] getConstraintsTriggeredUponBacktracking() {
        return this.constraintsTriggeredUponBacktracking;
    }

    public int[] getForcedSolution() {
        return this.forcedSolution;
    }

    public void incrementNbMergedConstraint() {
        ++this.nbMergedConstraints;
    }

    public void setNbUniversalConstraint(int nbUniversalConstraints) {
        this.nbUniversalConstraints = nbUniversalConstraints;
    }

    public void incrementNbDisconnectedVariables() {
        ++this.nbDisconnectedVariables;
    }

    public void incrementNbSingletonDomainVariables() {
        ++this.nbSingletonDomainVariables;
    }

    public void incrementNbUnaryConstraints(int offset) {
        this.nbUnaryConstraints += offset;
    }

    public void incrementNbGlobalConstraints(int offset) {
        this.nbGlobalConstraints += offset;
    }

    public int getNbUnaryConstraints() {
        return this.nbUnaryConstraints;
    }

    public int getNbGlobalConstraints() {
        return this.nbGlobalConstraints;
    }

    public void incrementNbMergedConstraints(int offset) {
        this.nbMergedConstraints += offset;
    }

    public long getNbConstraintChecks() {
        return this.nbConstraintChecks;
    }

    public long getNbValidityChecks() {
        return this.nbValidityChecks;
    }

    public void incrementNbValidityChecks() {
        ++this.nbValidityChecks;
    }

    public final void incrementNbConstraintChecks() {
        ++this.nbConstraintChecks;
    }

    public int getNbCurrentValues() {
        int cpt = 0;
        int i = 0;
        while (i < this.variables.length) {
            cpt += this.variables[i].getDomain().getCurrentSize();
            ++i;
        }
        return cpt;
    }

    public long getNbMaximumValues() {
        long cpt = 0L;
        int i = 0;
        while (i < this.variables.length) {
            cpt += (long)this.variables[i].getDomain().getMaximumSize();
            ++i;
        }
        return cpt;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public int getLevelInResolution() {
        return this.levelInResolution;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    protected boolean isAbstracted() {
        return this.levelInResolution < this.resolution.getNbAbstractionLevels();
    }

    public void setSolver(Solver solver) {
        this.solver = solver;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public int getNbVariables() {
        return this.variables.length;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public Variable getVariable(int i) {
        return this.variables[i];
    }

    public int getNbConstraints() {
        return this.constraints.length;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public Constraint getConstraint(int i) {
        return this.constraints[i];
    }

    public IParameters getParameters() {
        return this.parameters;
    }

    public PathManager getCliqueManager() {
        if (this.cliqueManager == null) {
            this.cliqueManager = new PathManager(this);
        }
        return this.cliqueManager;
    }

    public int getMinVariableDegree() {
        return this.minVariableDegree;
    }

    public int getMaxVariableDegree() {
        return this.maxVariableDegree;
    }

    public int getMinVariableDomainSize() {
        return this.minVariableDomainSize;
    }

    public int getMaxVariableDomainSize() {
        return this.maxVariableDomainSize;
    }

    public int getMaxConstraintArity() {
        return this.maxConstraintArity;
    }

    public long getMaxConstraintDomainSize() {
        return this.maxConstraintDomainSize;
    }

    public int getNbDomainTypes() {
        return this.nbDomainTypes;
    }

    public void setNbDomainTypes(int nbDomainTypes) {
        this.nbDomainTypes = nbDomainTypes;
    }

    public void incrementNbConvertedConstraints() {
        ++this.nbConvertedConstraints;
    }

    public void incrementNbConvertConstraintsChecksOf(int offset) {
        this.nbConvertConstraintsChecks += offset;
    }

    public void incrementNbExtensionStructures() {
        ++this.nbExtensionStructures;
    }

    public void incrementNbSharedExtensionStructures() {
        ++this.nbSharedExtensionStructures;
    }

    public void incrementNbConflictsStructures() {
        ++this.nbConflictsStructures;
    }

    public void decrementNbConflictsStructures() {
        --this.nbConflictsStructures;
    }

    public void incrementNbUnbuiltConflictsStructures() {
        ++this.nbUnbuiltConflictsStructures;
    }

    public void incrementNbSharedConflictstructures() {
        ++this.nbSharedConflictsStructures;
    }

    public void incrementNbEvaluationManagers() {
        ++this.nbEvaluationManagers;
    }

    public void incrementNbSharedEvaluationManagers() {
        ++this.nbSharedEvaluationManagers;
    }

    public int getNbSharedBinaryRepresentations() {
        return this.nbSharedBinaryRepresentations;
    }

    public void incrementNbSharedBinaryRepresentations() {
        ++this.nbSharedBinaryRepresentations;
    }

    public void setNbRelationTypes(int nbRelationTypes) {
        this.nbRelationTypes = nbRelationTypes;
    }

    public int getNbRelationTypes() {
        return this.nbRelationTypes;
    }

    public int getNbMaxAssignments() {
        int cpt = 0;
        int i = 0;
        while (i < this.variables.length) {
            cpt += this.variables[i].getDomain().getMaximumSize();
            ++i;
        }
        return cpt;
    }

    public AbsconConstants.MinMaxNo getOptimization() {
        return this.optimization;
    }

    public int getNbCollectedVariables() {
        return this.collectedVariables.size();
    }

    public Collection<Variable> getCollectedVariables() {
        return this.collectedVariables;
    }

    public int getNbCollectedConstraints() {
        return this.collectedConstraints.size();
    }

    public Collection<Constraint> getCollectedConstraints() {
        return this.collectedConstraints;
    }

    public Variable[] getPriorityVariables() {
        return new Variable[0];
    }

    public void resetCounters() {
        this.nbConstraintChecks = 0L;
        this.nbValidityChecks = 0L;
    }

    public void resetWeightedDegrees() {
        System.out.println("reset weights");
        Object[] objectArray = this.variables;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Variable variable = objectArray[n];
            variable.resetWeightedDegree();
            ++n;
        }
        objectArray = this.constraints;
        n = 0;
        n2 = objectArray.length;
        while (n < n2) {
            Object constraint = objectArray[n];
            ((Constraint)constraint).resetWeightedDegree();
            ++n;
        }
    }

    public long getDurationToBeBuilt() {
        return this.durationToBeBuilt;
    }

    public double getImpactAtCurrentDepth() {
        double d = 1.0;
        int i = 0;
        while (i < this.variables.length) {
            d *= this.variables[i].getDomain().getImpactAtCurrentDepth();
            ++i;
        }
        return 1.0 - d;
    }

    public void setDurationToBeBuilt(long l) {
        this.durationToBeBuilt = l;
    }

    public boolean hasOneVariableWithEmptyDomain() {
        int i = 0;
        while (i < this.variables.length) {
            if (this.variables[i].getCurrentDomainSize() == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updateConstraintDomainManagers(int nbRemovals) {
        int i = 0;
        while (i < this.constraints.length) {
            this.constraints[i].getDomainManager().setNbRecentDomainRemovals(nbRemovals);
            ++i;
        }
    }

    protected abstract void setParametersOfInstance(int var1);

    public final void addVariable(Variable variable) {
        variable.setId(this.collectedVariables.size());
        this.collectedVariables.add(variable);
        if (variable.getDomain().getMaximumSize() > this.maxVariableDomainSize) {
            this.maxVariableDomainSize = variable.getDomain().getMaximumSize();
        }
        if (variable.getDomain().getMaximumSize() < this.minVariableDomainSize) {
            this.minVariableDomainSize = variable.getDomain().getMaximumSize();
        }
    }

    protected abstract void addVariables();

    public final void addConstraint(Constraint constraint) {
        if (constraint instanceof GlobalConstraint) {
            this.containsGlobalConstraints = true;
        }
        if (!constraint.isVisible()) {
            return;
        }
        constraint.setId(this.collectedConstraints.size());
        this.collectedConstraints.add(constraint);
        this.maxConstraintArity = Math.max(this.maxConstraintArity, constraint.getArity());
        long size = constraint.getDomainManager().getCurrentDomainSize();
        if (this.maxConstraintDomainSize != -1L) {
            long l = this.maxConstraintDomainSize = size == -1L ? -1L : Math.max(this.maxConstraintDomainSize, size);
        }
        if (constraint instanceof AllDifferent) {
            this.collectedConstraintsTriggeredUponBacktracking.add(constraint);
        }
    }

    protected abstract void addConstraints();

    public void storeVariablesToArray() {
        this.variables = this.collectedVariables.toArray(new Variable[0]);
        if (this.resolution != null) {
            this.resolution.getOutputManager().outputMap("variables", this.getMapOVariablesAttributes(), 1);
        }
    }

    public void storeConstraintsToArray() {
        if (this.resolution != null && this.resolution.getNbAbstractionLevels() > 0) {
            return;
        }
        Stopwatch stopwatch = new Stopwatch();
        this.constraints = this.collectedConstraints.toArray(new Constraint[0]);
        this.constraintsTriggeredUponBacktracking = this.collectedConstraintsTriggeredUponBacktracking.toArray(new Constraint[0]);
        this.minVariableDegree = Integer.MAX_VALUE;
        this.maxVariableDegree = 0;
        Variable[] variableArray = this.variables;
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            variable.fixInvolvingConstraints();
            int variableDegree = variable.getDegree();
            if (variableDegree > this.maxVariableDegree) {
                this.maxVariableDegree = variableDegree;
            } else if (variableDegree < this.maxVariableDegree) {
                this.minVariableDegree = variableDegree;
            }
            ++n;
        }
        this.durationToBeBuilt += stopwatch.getCurrentWallClockTime();
        if (this.resolution != null) {
            this.resolution.getOutputManager().outputMap("constraints", this.getMapOfConstraintsAttributes(), 1);
        }
        assert (this.controlIds());
    }

    public void fixDomains() {
        Stopwatch stopwatch = new Stopwatch();
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].getDomain().fix();
            ++i;
        }
        this.durationToBeBuilt += stopwatch.getCurrentWallClockTime();
    }

    public boolean mustManageSymmetries() {
        return this.manageSymmetries;
    }

    private void managePrecliquesAndSymmetries() {
        int n;
        if (this.manageSymmetries && this.nbRelationTypes != -1) {
            SymmetryManager sm = new SymmetryManager();
            Variable[][] variableArray = sm.manage(this.variables, this.constraints);
            n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable[] classe = variableArray[n];
                if (sm.canBeExploited(classe)) {
                    int i = 0;
                    while (i < classe.length - 1) {
                        String predicate = Expr.lte(classe[i], classe[i + 1]);
                        UniversalConstraint constraint = new UniversalConstraint(this, new Variable[]{classe[i], classe[i + 1]}, predicate);
                        this.addConstraint(constraint);
                        ++i;
                    }
                    if (!this.resolution.isCompetition()) {
                        System.out.print(" clique-ordered :");
                        int j = 0;
                        while (j < classe.length) {
                            System.out.print(classe[j] + " ");
                            ++j;
                        }
                        System.out.println();
                    }
                }
                ++n;
            }
            this.storeConstraintsToArray();
        }
        if (this.buildPrecliques) {
            this.cliqueManager = new PathManager(this);
            Path[][] pathArray = this.cliqueManager.getPrepathes();
            int n3 = 0;
            n = pathArray.length;
            while (n3 < n) {
                Path[] preclique = pathArray[n3];
                if (preclique.length >= 3) {
                    this.addConstraint(new TrivialConstraint(this, new Variable[]{preclique[0].variable1, preclique[0].variable2}));
                }
                ++n3;
            }
            this.cliqueManager = null;
            this.storeConstraintsToArray();
        }
    }

    protected void attachToCore() {
        System.out.println("c   loading variables...");
        this.addVariables();
        this.storeVariablesToArray();
        System.out.println("c   loading constraints...");
        this.addConstraints();
        this.storeConstraintsToArray();
    }

    public boolean getShareSupportsOfBits() {
        return this.shareSupportsOfBits;
    }

    public void attachTo(Resolution resolution, int levelInResolution, int instanceNumber) {
        String optimizationTag = "problem/optim";
        String s = ConfigurationManager.getString(levelInResolution, optimizationTag, "value").toLowerCase();
        this.optimization = AbsconConstants.MinMaxNo.getOptimizationFor(s);
        if (this.optimization != AbsconConstants.MinMaxNo.NO) {
            double d = ConfigurationManager.getDouble(levelInResolution, optimizationTag, "initBound");
            this.currentBestSolution = d != -1.0 ? d : this.optimization.getOppositeExtremeValue();
            d = ConfigurationManager.getDouble(levelInResolution, optimizationTag, "limitBound");
            this.limitBestSolution = d != -1.0 ? d : this.optimization.getExtremeValue();
        }
        this.shareSupportsOfBits = ConfigurationManager.getBoolean(levelInResolution, "problem/shareSupportsOfBits", "value");
        this.resolution = resolution;
        this.levelInResolution = levelInResolution;
        this.instanceNumber = instanceNumber;
        this.setParametersOfInstance(instanceNumber);
        resolution.getOutputManager().outputMap("instance", this.getMapOfInstanceAttributes(), 1);
        if (!resolution.isCompetition()) {
            resolution.getOutputManager().save(resolution.getCurrentInstanceStopwatch().getCurrentWallClockTime());
        }
        this.attachToCore();
    }

    public int getNbConstraintsWithSimilarSignatures() {
        int cpt = 0;
        int i = 0;
        while (i < this.constraints.length) {
            int j = i + 1;
            while (j < this.constraints.length) {
                if (this.constraints[i].hasSetOfVariablesEqualTo(this.constraints[j].getInvolvedVariables())) {
                    ++cpt;
                }
                ++j;
            }
            ++i;
        }
        return cpt;
    }

    public double computeCurrentEvaluation() {
        throw new MissingImplementationException();
    }

    public boolean mustContinue() {
        if (!this.optimization.isOptimized()) {
            return true;
        }
        if (this.currentBestSolution == this.optimization.getOppositeExtremeValue()) {
            return true;
        }
        return this.computeCurrentEvaluation() < this.currentBestSolution;
    }

    public double getCurrentBestSolution() {
        return this.currentBestSolution;
    }

    public void dealWithNewSolution() {
        if (!this.optimization.isOptimized()) {
            return;
        }
        double currentSolution = this.computeCurrentEvaluation();
        System.out.println("<fitness solution='" + this.getSolver().getNbUniqueSolutions() + "'>" + currentSolution + " </fitness> <!-- (limit = " + this.limitBestSolution + ") -->");
        if (currentSolution < this.currentBestSolution) {
            this.currentBestSolution = currentSolution;
            if (this.currentBestSolution <= this.limitBestSolution) {
                this.resolution.setSuccessful(true);
            }
        }
    }

    public String getQuotes() {
        String s = "";
        int i = 1;
        while (i <= this.levelInResolution) {
            s = String.valueOf(s) + "'";
            ++i;
        }
        return s;
    }

    public String getName() {
        return "**problem" + this.levelInResolution + "**";
    }

    public String getExtendedName() {
        int nb = this.getNbConstraintsWithSimilarSignatures();
        String s = String.valueOf(this.getName()) + " with " + this.variables.length + " variables and " + this.constraints.length + " (" + nb + " similar-signatured) constraints";
        if (this.resolution == null || this.resolution.getConciseResults()) {
            return String.valueOf(s) + " (" + this.maxVariableDegree + " " + this.maxVariableDomainSize + " " + this.maxConstraintArity + " " + this.maxConstraintDomainSize + ")";
        }
        return String.valueOf(s) + "\n  parameters = " + this.getStringListOfParameters() + "\n  max variable degree = " + this.maxVariableDegree + "   max variable domain size = " + this.maxVariableDomainSize + "\n  max constraint arity = " + this.maxConstraintArity + "   max constraint domain size = " + this.maxConstraintDomainSize;
    }

    public String getDescription() {
        throw new MissingImplementationException();
    }

    public String getStringAssignment(Variable variable, int value) {
        return variable + ":=" + value;
    }

    public Map<String, String> getMapOfInstanceAttributes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.resolution.getNbAbstractionLevels() > 0) {
            map.put("level", String.valueOf(this.getLevelInResolution()));
        }
        map.put("name", this.getInstanceName());
        if (ArgumentsManager.getNbInstances() > 1) {
            map.put("number", String.valueOf(this.getInstanceNumber()));
        }
        if (!ArgumentsManager.getPackageName().equals(Tools.getRelativeParentPackageNameOf(Problem0.class))) {
            map.put("parameters", Reflector.getStringConcatenationOfDeclaredFieldsOf(this.getParameters()));
        }
        return map;
    }

    public Map<String, String> getMapOVariablesAttributes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("nbVariables", String.valueOf(this.getNbVariables()));
        map.put("nbDomainTypes", String.valueOf(this.nbDomainTypes));
        map.put("minDomainSize", String.valueOf(this.getMinVariableDomainSize()));
        map.put("maxDomainSize", String.valueOf(this.getMaxVariableDomainSize()));
        map.put("wckTime", String.valueOf((double)this.resolution.getCurrentInstanceStopwatch().getCurrentWallClockTime() / 1000.0));
        map.put("cpuTime", String.valueOf((double)this.resolution.getCurrentInstanceStopwatch().getCurrentCpuTime() / 1000.0));
        map.put("mem", Tools.getFormattedUsedMemorySize());
        return map;
    }

    public Map<String, String> getMapOfConstraintsAttributes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("nbConstraints", String.valueOf(this.getNbCollectedConstraints()));
        if (this.nbRelationTypes > 0) {
            map.put("nbRelationTypes", String.valueOf(this.nbRelationTypes));
        }
        if (this.nbUnaryConstraints > 0) {
            map.put("nbUnaryConstraints", String.valueOf(this.nbUnaryConstraints));
        }
        if (this.nbGlobalConstraints > 0) {
            map.put("nbGlobalConstraints", String.valueOf(this.nbGlobalConstraints));
        }
        if (this.nbMergedConstraints > 0) {
            map.put("nbMergedConstraints", String.valueOf(this.nbMergedConstraints));
        }
        if (this.nbUniversalConstraints > 0) {
            map.put("nbUniversalConstraints", String.valueOf(this.nbUniversalConstraints));
        }
        if (this.nbSingletonDomainVariables > 0) {
            map.put("nbSingletonDomainVariables", String.valueOf(this.nbSingletonDomainVariables));
        }
        if (this.nbDisconnectedVariables > 0) {
            map.put("nbDisconnectedVariables", String.valueOf(this.nbDisconnectedVariables));
        }
        if (this.nbConvertedConstraints > 0) {
            map.put("nbConvertedConstraints", String.valueOf(this.nbConvertedConstraints));
            map.put("nbConvertConstraintsChecks", String.valueOf(this.nbConvertConstraintsChecks));
        }
        if (this.nbExtensionStructures > 0) {
            map.put("nbExtensionStructures", String.valueOf(this.nbExtensionStructures));
            map.put("nbSharedExtensionStructures", String.valueOf(this.nbSharedExtensionStructures));
        }
        if (this.nbConflictsStructures > 0) {
            map.put("nbConflictsStructures", String.valueOf(this.nbConflictsStructures));
            map.put("nbSharedConflictsStructures", String.valueOf(this.nbSharedConflictsStructures));
        }
        if (this.nbUnbuiltConflictsStructures > 0) {
            map.put("nbUnbuiltConflictsStructures", String.valueOf(this.nbUnbuiltConflictsStructures));
        }
        map.put("nbSharedBinaryRepresentations", String.valueOf(this.nbSharedBinaryRepresentations));
        if (this.nbEvaluationManagers > 0) {
            map.put("nbEvaluationManagers", String.valueOf(this.nbEvaluationManagers));
            map.put("nbSharedEvaluationManagers", String.valueOf(this.nbSharedEvaluationManagers));
        }
        map.put("maxDegree", String.valueOf(this.getMaxVariableDegree()));
        map.put("maxArity", String.valueOf(this.getMaxConstraintArity()));
        map.put("wckTime", String.valueOf((double)this.resolution.getCurrentInstanceStopwatch().getCurrentWallClockTime() / 1000.0));
        map.put("cpuTime", String.valueOf((double)this.resolution.getCurrentInstanceStopwatch().getCurrentCpuTime() / 1000.0));
        map.put("mem", Tools.getFormattedUsedMemorySize());
        return map;
    }

    public void display() {
        System.out.println(this.getExtendedName());
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].display();
            ++i;
        }
        i = 0;
        while (i < this.constraints.length) {
            this.constraints[i].display();
            ++i;
        }
        System.out.println();
    }

    public void displayExhaustively() {
        System.out.println(this.getExtendedName());
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].displayExhaustively();
            ++i;
        }
        i = 0;
        while (i < this.constraints.length) {
            this.constraints[i].displayExhaustively();
            ++i;
        }
        System.out.println();
    }

    public String getStringListOfParameters() {
        StringBuffer sb = new StringBuffer();
        String[][] des = Reflector.getDescriptionOfDeclaredFieldsOf(this.parameters);
        int i = 0;
        while (i < des.length) {
            sb.append(des[i][0]);
            sb.append("=");
            sb.append(des[i][1]);
            sb.append(i < des.length - 1 ? " " : "");
            ++i;
        }
        return sb.toString();
    }

    public String getInstanceName() {
        String s = this.getName().replaceAll(" ", "");
        String[][] des = Reflector.getDescriptionOfDeclaredFieldsOf(this.parameters);
        int i = 0;
        while (i < des.length) {
            s = String.valueOf(s) + "_" + des[i][1];
            ++i;
        }
        return s;
    }

    public Document buildDocumentToBeSaved(boolean predicateForm) {
        return ProblemDocumentBuilder.buildDocumentOf(this, predicateForm, true);
    }

    public void saveXMLDescription(boolean predicateForm) {
        if (!this.resolution.getConciseResults()) {
            System.out.println("\t <!-- Start saving the XML description -->");
        }
        Document document = this.buildDocumentToBeSaved(predicateForm);
        Element predicatesElement = XMLManipulation.getFirstElementByTagNameFromRoot(document, "predicates");
        String s = this.getInstanceName();
        String ss = s.substring(s.lastIndexOf(File.separator) + 1);
        String fileName = String.valueOf(ss) + (this.nbMergedConstraints > 0 ? "_mgd" : "") + (predicatesElement != null || this.containsGlobalConstraints ? "" : "_ext") + ".xml";
        boolean format2 = ConfigurationManager.getDouble("//XCSP", "version") == 2.0;
        String styleSheetFileName = format2 ? "instance_2_0.xsl" : "instance_1_1.xsl";
        XMLManipulation.save(document, fileName, XMLManipulation.class.getResourceAsStream(styleSheetFileName));
        if (!this.resolution.getConciseResults()) {
            System.out.println("\t <!-- Stop saving the XML description of " + fileName + " -->");
        }
    }

    public void saveXMLDescription() {
        if (!ConfigurationManager.getBoolean("//saveProblemDescription", "value")) {
            return;
        }
        this.saveXMLDescription(ConfigurationManager.getBoolean("//saveProblemDescription", "intention"));
    }

    public int countNbValidSupports() {
        int cpt = 0;
        Constraint[] constraintArray = this.constraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            int[] t = constraint.getTupleManager().getLocalTuple();
            boolean anotherSupport = constraint.getFirstSupport(t);
            while (anotherSupport) {
                ++cpt;
                anotherSupport = constraint.getNextSupport(t);
            }
            ++n;
        }
        return cpt;
    }

    private boolean controlIds() {
        int i = 0;
        while (i < this.variables.length) {
            if (i != this.variables[i].getId()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.constraints.length) {
            if (i != this.constraints[i].getId()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean controlNotEmptyDomains() {
        int i = 0;
        while (i < this.variables.length) {
            if (this.variables[i].getCurrentDomainSize() == 0) {
                System.out.println(this.variables[i] + " with empty domain");
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean controlFullDomains() {
        int i = 0;
        while (i < this.variables.length) {
            if (!this.variables[i].getDomain().getElements().controlFullness()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

