/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.variableOrdering.statc;

import abscon.heuristics.variableOrdering.VariableOrderingHeuristic;
import abscon.problem.Variable;
import abscon.solvers.systematicSolvers.SystematicSolver;

public abstract class StaticVariableOrderingHeuristic
extends VariableOrderingHeuristic {
    protected Variable[] order;
    protected double[] evaluations;

    public void attachTo(SystematicSolver solver) {
        super.attachTo(solver);
        this.order = new Variable[solver.getNbVariables()];
        this.evaluations = new double[solver.getNbVariables()];
    }

    private void swap(int i, int j) {
        Variable variable = this.order[i];
        this.order[i] = this.order[j];
        this.order[j] = variable;
        double evaluation = this.evaluations[i];
        this.evaluations[i] = this.evaluations[j];
        this.evaluations[j] = evaluation;
    }

    private void performLightShuffle() {
        if (!this.randomization) {
            return;
        }
        int i = 1;
        while (i < this.order.length) {
            if (this.evaluations[i - 1] - this.evaluations[i] <= this.randomizationEquivalenceLimit && this.random.nextDouble() <= 0.5) {
                this.swap(i - 1, i);
            }
            ++i;
        }
    }

    protected void evaluateAndSortVariables() {
        int i = 0;
        while (i < this.order.length) {
            this.evaluations[i] = this.computeGlobalEvaluationOf(this.order[i]);
            ++i;
        }
        i = 0;
        while (i < this.order.length - 1) {
            int best = i;
            int j = i + 1;
            while (j < this.order.length) {
                if (this.evaluations[j] > this.evaluations[best]) {
                    best = j;
                }
                ++j;
            }
            this.swap(i, best);
            ++i;
        }
    }

    public void initializeBeforeSearch() {
        System.arraycopy(this.solver.getVariables(), 0, this.order, 0, this.order.length);
        this.evaluateAndSortVariables();
        this.performLightShuffle();
    }

    protected Variable getNextUnpriorityVariable() {
        int index = this.solver.getVariableManager().getNbPastVariables();
        while (!this.order[index].isFuture()) {
            ++index;
        }
        return this.order[index];
    }

    public void displaySortedVariables() {
        System.out.print("Statically ordered variables : ");
        int i = 0;
        while (i < this.order.length) {
            System.out.print(this.order[i] + " ");
            ++i;
        }
        System.out.println();
    }
}

