/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.variableOrdering.dynamic;

import abscon.heuristics.variableOrdering.dynamic.DynamicVariableOrderingHeuristic;
import abscon.problem.Variable;
import abscon.tools.KMeansClustering;
import abscon.tools.absconParameters.ConfigurationManager;

public class WDegOnDom
extends DynamicVariableOrderingHeuristic {
    private static int nbRuns = 0;
    private static int resetPeriod = Integer.MAX_VALUE;
    private WeigthClustering wc;

    public void initializeBeforeSearch() {
        String s = "search/variableHeuristic";
        resetPeriod = ConfigurationManager.getInt(this.solver.getLevelInResolution(), s, "resetPeriod");
        if (resetPeriod == -1) {
            resetPeriod = Integer.MAX_VALUE;
        }
        ++nbRuns;
        if (resetPeriod == 0) {
            if (this.wc == null) {
                this.wc = new WeigthClustering();
            }
            long weight = this.wc.recluster();
            Variable[] variableArray = this.solver.getVariables();
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable variable = variableArray[n];
                if (variable.getWeightedDegree() <= weight) {
                    variable.setWeightedDegree(0L);
                } else {
                    variable.setWeightedDegree(weight);
                }
                ++n;
            }
        } else if (nbRuns % resetPeriod == 0) {
            this.solver.getProblem().resetWeightedDegrees();
        }
    }

    protected double evaluate(Variable variable) {
        return (double)variable.getWeightedDegree() / (double)variable.getDomain().getCurrentSize();
    }

    class WeigthClustering
    extends KMeansClustering {
        WeigthClustering() {
        }

        public int getNbValues() {
            return WDegOnDom.this.solver.getNbVariables();
        }

        public long getValue(int index) {
            return WDegOnDom.this.solver.getVariable(index).getWeightedDegree();
        }
    }
}

