/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.variableOrdering.dynamic;

import abscon.exceptions.UnreachableCodeException;
import abscon.heuristics.variableOrdering.VariableOrderingHeuristic;
import abscon.problem.Variable;
import abscon.solvers.systematicSolvers.SystematicSolver;

public abstract class DynamicVariableSelectingHeuristic
extends VariableOrderingHeuristic {
    protected double bestEvaluation;
    protected boolean last;
    protected double[] probabilityDistribution;

    public void attachTo(SystematicSolver solver) {
        super.attachTo(solver);
        this.probabilityDistribution = new double[solver.getNbVariables()];
    }

    protected Variable getNextUnpriorityVariable() {
        assert (this.solver.getVariableManager().getNbFutureVariables() > 0);
        double maxProbability = -1.7976931348623157E308;
        double minProbability = Double.MAX_VALUE;
        int i = 0;
        while (i < this.solver.getNbVariables()) {
            if (this.solver.getVariable(i).isFuture()) {
                this.probabilityDistribution[i] = this.computeGlobalEvaluationOf(this.solver.getVariable(i));
                maxProbability = Math.max(maxProbability, this.probabilityDistribution[i]);
                minProbability = Math.min(minProbability, this.probabilityDistribution[i]);
            }
            ++i;
        }
        if (maxProbability == minProbability) {
            return this.solver.getFirstFutureVariable();
        }
        double totalProbability = 0.0;
        if (this.randomizationEquivalenceLimit >= 1.0) {
            int i2 = 0;
            while (i2 < this.probabilityDistribution.length) {
                if (!this.solver.getVariable(i2).isFuture() || this.probabilityDistribution[i2] < maxProbability) {
                    this.probabilityDistribution[i2] = 0.0;
                } else {
                    this.probabilityDistribution[i2] = 1.0;
                    totalProbability += 1.0;
                }
                ++i2;
            }
        } else if (this.randomizationEquivalenceLimit <= 0.0) {
            int i3 = 0;
            while (i3 < this.probabilityDistribution.length) {
                if (!this.solver.getVariable(i3).isFuture()) {
                    this.probabilityDistribution[i3] = 0.0;
                } else {
                    this.probabilityDistribution[i3] = 1.0;
                    totalProbability += 1.0;
                }
                ++i3;
            }
        } else {
            double minP = this.randomizationEquivalenceLimit / (1.0 - this.randomizationEquivalenceLimit);
            int i4 = 0;
            while (i4 < this.probabilityDistribution.length) {
                if (!this.solver.getVariable(i4).isFuture()) {
                    this.probabilityDistribution[i4] = 0.0;
                } else {
                    this.probabilityDistribution[i4] = Math.pow(minP, (this.probabilityDistribution[i4] - minProbability) / (maxProbability - minProbability));
                    totalProbability += this.probabilityDistribution[i4];
                }
                ++i4;
            }
        }
        double chosen = this.random.nextDouble() * totalProbability;
        totalProbability = 0.0;
        int currentVariable = 0;
        while (currentVariable < this.solver.getNbVariables()) {
            if (chosen < (totalProbability += this.probabilityDistribution[currentVariable])) {
                return this.solver.getVariable(currentVariable);
            }
            ++currentVariable;
        }
        throw new UnreachableCodeException("chosen : " + chosen + ", totalProbability : " + totalProbability);
    }

    public void initializeBeforeSearch() {
    }
}

