/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.variableOrdering.dynamic;

import abscon.heuristics.variableOrdering.VariableOrderingHeuristic;
import abscon.problem.Variable;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.absconParameters.ConfigurationManager;

public abstract class DynamicVariableOrderingHeuristic
extends VariableOrderingHeuristic {
    protected int nbTiedVariables;
    protected Variable[] tiedVariables;
    protected double bestEvaluation;
    protected int lastMode;
    private boolean neighbourForcing = true;

    public void attachTo(SystematicSolver solver) {
        super.attachTo(solver);
        this.tiedVariables = new Variable[solver.getNbVariables()];
        this.lastMode = ConfigurationManager.getInt(solver.getLevelInResolution(), "search/variableHeuristic", "last");
    }

    private void startNewTieWith(Variable variable, double evaluation) {
        this.bestEvaluation = evaluation;
        this.tiedVariables[0] = variable;
        this.nbTiedVariables = 1;
    }

    protected void updateTieWith(Variable variable) {
        double evaluation = this.computeGlobalEvaluationOf(variable);
        if (this.randomization) {
            double difference = evaluation - this.bestEvaluation;
            if (difference > this.randomizationEquivalenceLimit) {
                this.startNewTieWith(variable, evaluation);
            } else if (difference >= -this.randomizationEquivalenceLimit) {
                this.tiedVariables[this.nbTiedVariables++] = variable;
            }
        } else if (evaluation > this.bestEvaluation) {
            this.startNewTieWith(variable, evaluation);
        }
    }

    protected Variable chooseVariableInTie() {
        assert (this.nbTiedVariables > 0);
        return this.randomization ? this.tiedVariables[this.random.nextInt(this.nbTiedVariables)] : this.tiedVariables[0];
    }

    protected Variable getNextUnpriorityVariable() {
        assert (this.solver.getVariableManager().getNbFutureVariables() > 0);
        if (this.lastMode > 0 && this.solver.getLastConflictPriorityVariable() != null) {
            return this.solver.getLastConflictPriorityVariable();
        }
        this.nbTiedVariables = 0;
        this.bestEvaluation = Double.NEGATIVE_INFINITY;
        Variable variable = this.solver.getFirstFutureVariable();
        while (variable != null) {
            this.updateTieWith(variable);
            variable = this.solver.getNextFutureVariableAfter(variable);
        }
        return this.chooseVariableInTie();
    }

    public void displayCurrentTie() {
        System.out.println();
        System.out.print("Current tie at depth " + this.solver.getCurrentDepth());
        System.out.print(" with " + this.nbTiedVariables + " variables : ");
        int i = 0;
        while (i < this.nbTiedVariables) {
            System.out.print(" " + this.tiedVariables[i].getId());
            ++i;
        }
        System.out.println();
    }

    public void initializeBeforeSearch() {
    }
}

