/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.variableOrdering.advanced;

import abscon.heuristics.variableOrdering.advanced.AdvancedDynamicVariableOrderingHeuristic;
import abscon.problem.Variable;
import abscon.solvers.GraphManager;
import abscon.solvers.systematicSolvers.SystematicSolver;

public class ArticulationVariable
extends AdvancedDynamicVariableOrderingHeuristic {
    private GraphManager graphManager;

    public void attachTo(SystematicSolver solver) {
        super.attachTo(solver);
        this.graphManager = new GraphManager(solver);
    }

    protected double evaluate(Variable variable) {
        double dd = variable.getDynamicDegree();
        return dd == 0.0 ? 0.0 : -((double)variable.getDomain().getCurrentSize() / dd);
    }

    protected void fillSelection() {
        this.selectionLeftFrontier = 0;
        Variable articulation = this.graphManager.findFirstArticulation(false);
        if (articulation == null) {
            articulation = this.graphManager.findFirstVariableInArticulationPair();
        }
        if (articulation != null) {
            this.selectionStrictRightFrontier = 1;
            this.selection[0] = articulation;
            return;
        }
        this.graphManager.determineConnexComponentsIn(this.solver.getVariables(), 0, this.solver.getNbVariables() - 1);
        this.selectionStrictRightFrontier = this.graphManager.getBestComponentSize();
        Variable[] bestComponent = this.graphManager.getBestComponent();
        int i = 0;
        while (i < this.selectionStrictRightFrontier) {
            this.selection[i] = bestComponent[i];
            ++i;
        }
    }

    protected Variable revisitSelection() {
        this.graphManager.determineConnexComponentsIn(this.solver.getVariables(), 0, this.solver.getNbVariables() - 1);
        Variable articulation = this.graphManager.findFirstArticulation(false);
        if (articulation == null) {
            articulation = this.graphManager.findFirstVariableInArticulationPair();
        }
        if (articulation != null) {
            this.selectionLeftFrontier = 0;
            this.selectionStrictRightFrontier = 1;
            this.selection[0] = articulation;
            return articulation;
        }
        this.graphManager.determineConnexComponentsIn(this.solver.getVariables(), 0, this.solver.getNbVariables() - 1);
        int nbComponents = this.graphManager.getNbComponents();
        if (nbComponents <= 1) {
            return super.revisitSelection();
        }
        this.selectionLeftFrontier = 0;
        this.selectionStrictRightFrontier = this.graphManager.getBestComponentSize();
        Variable[] bestComponent = this.graphManager.getBestComponent();
        int i = 0;
        while (i < this.selectionStrictRightFrontier) {
            this.selection[i] = bestComponent[i];
            ++i;
        }
        this.displayCurrentSelection();
        if (this.selectionManager != null && this.selectionStrictRightFrontier > 1) {
            this.selectionManager.insertCurrentSelection();
        }
        Variable variable = this.getBestOfSelectedVariables();
        assert (variable != null);
        return variable;
    }
}

