/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.variableOrdering.advanced;

import abscon.heuristics.variableOrdering.dynamic.DynamicVariableOrderingHeuristic;
import abscon.problem.Variable;
import abscon.solvers.systematicSolvers.SystematicSolver;
import java.util.Arrays;

public abstract class AdvancedDynamicVariableOrderingHeuristic
extends DynamicVariableOrderingHeuristic {
    protected Variable[] selection;
    protected int selectionStrictRightFrontier;
    protected int selectionLeftFrontier;
    protected boolean dynamicSelections;
    protected SelectionManager selectionManager;
    protected int lastDepth;

    public void attachTo(SystematicSolver solver) {
        super.attachTo(solver);
        this.selection = new Variable[solver.getNbVariables()];
    }

    public void initializeBeforeSearch() {
        super.initializeBeforeSearch();
        this.selectionLeftFrontier = 0;
        this.selectionStrictRightFrontier = 0;
        this.lastDepth = -1;
        if (this.selectionManager != null) {
            this.selectionManager.initialize();
        }
    }

    protected Variable getBestOfSelectedVariables() {
        this.nbTiedVariables = 0;
        this.bestEvaluation = Double.NEGATIVE_INFINITY;
        int index = this.selectionLeftFrontier;
        while (index < this.selectionStrictRightFrontier) {
            if (!this.selection[index].isFuture()) {
                if (index != this.selectionLeftFrontier) {
                    this.selection[index] = this.selection[this.selectionLeftFrontier];
                }
                ++this.selectionLeftFrontier;
            } else {
                this.updateTieWith(this.selection[index]);
            }
            ++index;
        }
        return this.nbTiedVariables == 0 ? null : this.chooseVariableInTie();
    }

    abstract void fillSelection();

    protected Variable performNewSelection() {
        this.selectionLeftFrontier = 0;
        this.fillSelection();
        this.displayCurrentSelection();
        if (this.selectionManager != null && this.selectionStrictRightFrontier > 1) {
            this.selectionManager.insertCurrentSelection();
        }
        Variable variable = this.getBestOfSelectedVariables();
        assert (variable != null);
        return variable;
    }

    protected Variable revisitSelection() {
        Variable variable = this.getBestOfSelectedVariables();
        return variable == null ? this.performNewSelection() : variable;
    }

    /*
     * Unable to fully structure code
     */
    protected Variable getNextUnpriorityVariable() {
        depth = this.solver.getCurrentDepth();
        progression = depth > this.lastDepth;
        this.lastDepth = depth;
        if (!progression) {
            if (this.selectionManager == null || this.solver.getVariableManager().getNbPastVariables() == 0) {
                return this.performNewSelection();
            }
            this.selectionManager.popOldSelectionOf(this.solver.getVariableManager().getLastPastVariable());
            if (this.selectionStrictRightFrontier == 0) {
                return this.performNewSelection();
            }
            variable = this.getBestOfSelectedVariables();
            if (!AdvancedDynamicVariableOrderingHeuristic.$assertionsDisabled && variable == null) {
                throw new AssertionError();
            }
            return variable;
        }
        if (!this.dynamicSelections) ** GOTO lbl17
        return this.revisitSelection();
lbl-1000:
        // 1 sources

        {
            ++this.selectionLeftFrontier;
lbl17:
            // 2 sources

            ** while (this.selectionLeftFrontier < this.selectionStrictRightFrontier && !this.selection[this.selectionLeftFrontier].isFuture())
        }
lbl18:
        // 1 sources

        if (this.selectionLeftFrontier >= this.selectionStrictRightFrontier) {
            return this.performNewSelection();
        }
        return this.selection[this.selectionLeftFrontier++];
    }

    public void displayCurrentSelection() {
        System.out.println();
        System.out.print("Current selection at depth " + this.solver.getCurrentDepth());
        System.out.print(" with " + this.selectionStrictRightFrontier + " variables : ");
        int i = 0;
        while (i < this.selectionStrictRightFrontier) {
            System.out.print(" " + this.selection[i].getId());
            ++i;
        }
        System.out.println();
    }

    class SelectionManager {
        private int nbSelections;
        private int[] firstVariable;
        private int[] nextVariable;
        private int[] selectionOfVariable;
        private Variable[] variables;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !SelectionManager.class.desiredAssertionStatus();
        }

        public SelectionManager() {
            this.variables = AdvancedDynamicVariableOrderingHeuristic.this.solver.getVariables();
            this.firstVariable = new int[this.variables.length];
            this.nextVariable = new int[this.variables.length];
            this.selectionOfVariable = new int[this.variables.length];
            this.initialize();
        }

        public void initialize() {
            this.nbSelections = 0;
            Arrays.fill(this.selectionOfVariable, -1);
        }

        public void popOldSelectionOf(Variable variable) {
            if (this.selectionOfVariable[variable.getId()] == -1) {
                AdvancedDynamicVariableOrderingHeuristic.this.selectionStrictRightFrontier = 0;
                return;
            }
            int cpt = 0;
            this.nbSelections = this.selectionOfVariable[variable.getId()];
            int id = this.firstVariable[this.nbSelections];
            while (id != -1) {
                if (this.variables[id].isFuture()) {
                    AdvancedDynamicVariableOrderingHeuristic.this.selection[cpt++] = this.variables[id];
                }
                id = this.nextVariable[id];
            }
            AdvancedDynamicVariableOrderingHeuristic.this.selectionStrictRightFrontier = cpt;
            AdvancedDynamicVariableOrderingHeuristic.this.selectionLeftFrontier = 0;
        }

        public void insertCurrentSelection() {
            if (!$assertionsDisabled && AdvancedDynamicVariableOrderingHeuristic.this.selectionStrictRightFrontier <= 0) {
                throw new AssertionError();
            }
            this.firstVariable[this.nbSelections] = AdvancedDynamicVariableOrderingHeuristic.this.selection[0].getId();
            int i = 0;
            while (i < AdvancedDynamicVariableOrderingHeuristic.this.selectionStrictRightFrontier - 1) {
                this.nextVariable[AdvancedDynamicVariableOrderingHeuristic.this.selection[i].getId()] = AdvancedDynamicVariableOrderingHeuristic.this.selection[i + 1].getId();
                this.selectionOfVariable[AdvancedDynamicVariableOrderingHeuristic.this.selection[i].getId()] = this.nbSelections;
                ++i;
            }
            this.nextVariable[AdvancedDynamicVariableOrderingHeuristic.this.selection[AdvancedDynamicVariableOrderingHeuristic.this.selectionStrictRightFrontier - 1].getId()] = -1;
            this.selectionOfVariable[AdvancedDynamicVariableOrderingHeuristic.this.selection[AdvancedDynamicVariableOrderingHeuristic.this.selectionStrictRightFrontier - 1].getId()] = this.nbSelections++;
        }
    }
}

