/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.variableOrdering;

import abscon.constants.AbsconConstants;
import abscon.problem.Variable;
import abscon.solvers.Solver;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.absconParameters.ConfigurationManager;
import java.util.Random;

public abstract class VariableOrderingHeuristic {
    protected SystematicSolver solver;
    protected AbsconConstants.MinMaxNo optimization;
    protected int neighbourhoodLevel;
    protected char neighbourhoodOperator;
    protected boolean randomization;
    protected double randomizationEquivalenceLimit;
    protected Random random;
    protected Variable[] priorityVariables;

    public Solver getSolver() {
        return this.solver;
    }

    public void attachTo(SystematicSolver solver) {
        this.solver = solver;
        String variableTag = "search/variableHeuristic";
        String s = ConfigurationManager.getString(solver.getLevelInResolution(), variableTag, "optim");
        this.optimization = AbsconConstants.MinMaxNo.getOptimizationFor(s);
        this.neighbourhoodLevel = ConfigurationManager.getInt(solver.getLevelInResolution(), String.valueOf(variableTag) + "/" + "multiLevel", "value");
        if (this.neighbourhoodLevel < 0) {
            throw new IllegalArgumentException("multilevel value must be greater than or equal to 0");
        }
        this.neighbourhoodOperator = ConfigurationManager.getString(solver.getLevelInResolution(), String.valueOf(variableTag) + "/" + "multiLevel", "operator").charAt(0);
        if (this.neighbourhoodOperator != '+' && this.neighbourhoodOperator != '*') {
            throw new IllegalArgumentException("operator must be '+' or '*'");
        }
        this.randomization = ConfigurationManager.getBoolean(solver.getLevelInResolution(), String.valueOf(variableTag) + "/" + "randomization", "enabled");
        this.randomizationEquivalenceLimit = ConfigurationManager.getDouble(solver.getLevelInResolution(), String.valueOf(variableTag) + "/" + "randomization", "equiv");
        this.random = solver.getResolution().getRandom();
        this.priorityVariables = solver.getProblem().getPriorityVariables();
    }

    public abstract void initializeBeforeSearch();

    protected abstract double evaluate(Variable var1);

    protected double evaluate(Variable variable, int level) {
        double localEvaluation = this.evaluate(variable);
        if (level == 0) {
            return localEvaluation;
        }
        double result = 0.0;
        int cpt = 0;
        VariableManager variableManager = this.solver.getVariableManager();
        Variable[] neighbours = variable.getNeighbours();
        if (neighbours != null && neighbours.length <= variableManager.getNbFutureVariables()) {
            Variable[] variableArray = neighbours;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable neighbour = variableArray[n];
                if (neighbour.isFuture()) {
                    ++cpt;
                    double neighbourEvaluation = this.evaluate(neighbour, level - 1);
                    result += this.neighbourhoodOperator == '+' ? localEvaluation + neighbourEvaluation : localEvaluation * neighbourEvaluation;
                }
                ++n;
            }
        } else {
            Variable var = variableManager.getFirstFutureVariable();
            while (var != null) {
                if (variable != var && variable.isNeighbourOf(var)) {
                    ++cpt;
                    double neighbourEvaluation = this.evaluate(var, level - 1);
                    result += this.neighbourhoodOperator == '+' ? localEvaluation + neighbourEvaluation : localEvaluation * neighbourEvaluation;
                }
                var = variableManager.getNextFutureVariableAfter(var);
            }
        }
        if (cpt == 0) {
            return Double.MAX_VALUE;
        }
        return result / (double)(cpt * cpt);
    }

    protected double computeGlobalEvaluationOf(Variable variable) {
        double d = this.evaluate(variable, this.neighbourhoodLevel);
        return this.optimization.isMin() ? -d : d;
    }

    protected abstract Variable getNextUnpriorityVariable();

    public Variable getNextVariable() {
        int nbPastVariables = this.solver.getVariableManager().getNbPastVariables();
        if (nbPastVariables < this.priorityVariables.length) {
            return this.priorityVariables[nbPastVariables];
        }
        return this.getNextUnpriorityVariable();
    }

    public double getEvaluation(Variable v) {
        return this.evaluate(v);
    }
}

