/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.valueOrdering.statc;

import abscon.constraints.Constraint;
import abscon.constraints.TupleManager;
import abscon.heuristics.valueOrdering.statc.StaticValueOrderingHeuristic;
import abscon.problem.Variable;

public class NbWeightedSupports
extends StaticValueOrderingHeuristic {
    private static boolean initialized;
    private static int[][] nbWeightedSupports;

    public void initializeBeforeSearch() {
        if (!initialized) {
            Variable[] variables = this.variable.getProblem().getVariables();
            nbWeightedSupports = new int[variables.length][];
            int i = 0;
            while (i < nbWeightedSupports.length) {
                NbWeightedSupports.nbWeightedSupports[i] = new int[variables[i].getDomain().getMaximumSize()];
                ++i;
            }
            Constraint[] constraintArray = this.variable.getProblem().getConstraints();
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                TupleManager tupleManager = constraint.getTupleManager();
                int[] tuple = tupleManager.getLocalTuple();
                tupleManager.setFirstTupleFromScratch(tuple);
                do {
                    if (!constraint.checkTupleOfIndexes(tuple)) continue;
                    int i2 = 0;
                    while (i2 < constraint.getNbInvolvedVariables()) {
                        int cpt = 0;
                        int j = 0;
                        while (j < constraint.getNbInvolvedVariables()) {
                            if (i2 != j) {
                                cpt = (int)((long)cpt + (constraint.getDomainManager().getCurrentDomainSizeExcluding(j) - (long)constraint.getConflictsStructure().getNbInitialConflictsFor(j, tuple[j])));
                            }
                            ++j;
                        }
                        int[] nArray = nbWeightedSupports[constraint.getInvolvedVariable(i2).getId()];
                        int n3 = tuple[i2];
                        nArray[n3] = nArray[n3] + cpt;
                        ++i2;
                    }
                } while (tupleManager.setNextTuple() != -1);
                ++n;
            }
            initialized = true;
        }
        super.initializeBeforeSearch();
    }

    public void evaluate(int index) {
        this.currentEvaluations[index] = nbWeightedSupports[this.variable.getId()][index];
    }
}

