/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.valueOrdering.statc;

import abscon.constraints.Constraint;
import abscon.constraints.TupleManager;
import abscon.heuristics.valueOrdering.statc.StaticValueOrderingHeuristic;
import abscon.problem.Variable;

public class MinInvers
extends StaticValueOrderingHeuristic {
    protected int[] nbSupports;
    private static int initialized;

    public void attachTo(Variable variable) {
        super.attachTo(variable);
        initialized = -1;
    }

    public void initializeBeforeSearch() {
        if (this.getVariable().getProblem().getSolver().getRestarter().getCurrentRun() > initialized) {
            Variable[] variableArray = this.getVariable().getProblem().getVariables();
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable v = variableArray[n];
                ((MinInvers)v.getValueOrderingHeuristic()).setSupports();
                ++n;
            }
            initialized = this.getVariable().getProblem().getSolver().getRestarter().getCurrentRun();
        }
        super.initializeBeforeSearch();
    }

    private void setSupports() {
        this.nbSupports = new int[this.variable.getDomain().getMaximumSize()];
        int index = 0;
        while (index < this.nbSupports.length) {
            int cpt = 0;
            if (this.variable.getDomain().getElements().isPresent(index)) {
                Constraint[] constraintArray = this.variable.getInvolvingConstraints();
                int n = 0;
                int n2 = constraintArray.length;
                while (n < n2) {
                    Constraint constraint = constraintArray[n];
                    int variablePosition = constraint.getPositionOf(this.variable);
                    int nb = constraint.getConflictsStructure().getNbInitialConflictsFor(variablePosition, index);
                    cpt += nb != -1 ? nb : constraint.computeNbTuplesFor(variablePosition, index, true);
                    ++n;
                }
            }
            this.nbSupports[index] = cpt;
            ++index;
        }
    }

    public int getNbSupports(int index) {
        return this.nbSupports[index];
    }

    public void evaluate(int index) {
        int cpt = 0;
        Constraint[] constraintArray = this.variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            TupleManager tupleManager = new TupleManager(constraint);
            tupleManager.setFirstTupleFromScratch(tupleManager.getLocalTuple(), constraint.getPositionOf(this.variable), index);
            do {
                int[] tuple;
                if (!constraint.checkTupleOfIndexes(tuple = tupleManager.getCurrentTuple())) continue;
                Variable[] variableArray = constraint.getInvolvedVariables();
                int n3 = 0;
                int n4 = variableArray.length;
                while (n3 < n4) {
                    Variable v = variableArray[n3];
                    if (v != this.variable) {
                        cpt += ((MinInvers)v.getValueOrderingHeuristic()).getNbSupports(tuple[constraint.getPositionOf(v)]);
                    }
                    ++n3;
                }
            } while (tupleManager.setNextTuple() != -1);
            ++n;
        }
        this.currentEvaluations[index] = cpt;
    }
}

