/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.valueOrdering;

import abscon.constants.AbsconConstants;
import abscon.heuristics.valueOrdering.SelectionManager;
import abscon.heuristics.valueOrdering.dynamic.DynamicSelectionManager;
import abscon.heuristics.valueOrdering.statc.StaticSelectionManager;
import abscon.heuristics.valueOrdering.statc.StaticValueOrderingHeuristic;
import abscon.problem.Variable;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;
import abscon.tools.math.Statistics;
import java.util.Random;

public abstract class ValueOrderingHeuristic {
    protected static Random random;
    protected Variable variable;
    protected SelectionManager selectionManager;
    protected static AbsconConstants.MinMaxNo optimization;
    protected double[] currentEvaluations;

    public Variable getVariable() {
        return this.variable;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void attachTo(Variable variable) {
        this.variable = variable;
        this.currentEvaluations = new double[variable.getDomain().getMaximumSize()];
        int level = variable.getProblem().getLevelInResolution();
        String valueTag = "search/valueHeuristic";
        String s = ConfigurationManager.getString(level, valueTag, "optim");
        if (optimization == null) {
            optimization = AbsconConstants.MinMaxNo.getOptimizationFor(s);
        }
        int selectionWidth = ConfigurationManager.getInt(level, valueTag, "width");
        this.selectionManager = this instanceof StaticValueOrderingHeuristic ? new StaticSelectionManager(this, selectionWidth) : new DynamicSelectionManager(this, selectionWidth);
        random = variable.getProblem().getResolution().getRandom();
    }

    public abstract void initializeBeforeSearch();

    public void initializeBeforeRun() {
    }

    protected abstract void evaluate(int var1);

    protected double isBetterThan(int i, int j) {
        double difference = this.currentEvaluations[i] - this.currentEvaluations[j];
        return optimization.isMin() ? -difference : difference;
    }

    public int searchBestElement() {
        int index;
        Elements elements = this.variable.getDomain().getElements();
        int bestIndex = index = elements.getFirstPresent();
        this.evaluate(index);
        int i = 1;
        while (i < elements.getNbPresentElements()) {
            index = elements.getNextPresent(index);
            this.evaluate(index);
            if (this.isBetterThan(index, bestIndex) > 0.0) {
                bestIndex = index;
            }
            ++i;
        }
        return bestIndex;
    }

    public void storeSeveralElements(int[] t, int nbElements) {
        int cpt = 0;
        Elements elements = this.variable.getDomain().getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            this.evaluate(index);
            t[cpt++] = index;
            index = elements.getNextPresent(index);
        }
        int i = 0;
        while (i < nbElements) {
            int indMin = i;
            int j = i + 1;
            while (j < nbElements) {
                if (this.isBetterThan(t[j], t[indMin]) > 0.0) {
                    indMin = j;
                }
                ++j;
            }
            int tmp = t[i];
            t[i] = t[indMin];
            t[indMin] = tmp;
            ++i;
        }
    }

    public abstract int getBestValue();

    public double getEvaluation(int index) {
        return this.currentEvaluations[index];
    }

    public void displayCurrentEvaluations() {
        System.out.print(this.variable + " : ");
        System.out.println(" mean = " + Statistics.computeMeanOf(this.currentEvaluations) + " sd = " + Statistics.computeStandardDeviationOf(this.currentEvaluations));
    }
}

