/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.universal;

import abscon.constants.Expr;
import abscon.constants.XMLInstanceRepresentation;
import abscon.constraints.ConflictsStructure;
import abscon.constraints.Constraint;
import abscon.constraints.universal.caches.Cache;
import abscon.constraints.universal.evaluators.EvaluationManager;
import abscon.heuristics.valueOrdering.statc.RawLexico;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.propagationTechniques.revisionManagers.RevisionManager0;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ConfigurationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class UniversalConstraint
extends Constraint {
    private static Map<String, EvaluationManager> map = new HashMap<String, EvaluationManager>();
    private String universalPredicateExpression;
    private EvaluationManager manager;
    private Cache cache;

    public static void clear() {
        map.clear();
    }

    public EvaluationManager getEvaluationManager() {
        return this.manager;
    }

    private static Variable[] searchVariablesFrom(Problem problem, String predicate) {
        Variable[] variables = problem.getVariables();
        ArrayList<Variable> list = new ArrayList<Variable>();
        String canonizedPredicate = Expr.formatPredicate(predicate);
        StringTokenizer st = new StringTokenizer(canonizedPredicate);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int i = 0;
            while (i < variables.length) {
                if (variables[i].getName().equals(token) && !list.contains(variables[i])) {
                    list.add(variables[i]);
                }
                ++i;
            }
        }
        return list.toArray(new Variable[0]);
    }

    public static boolean mustBuildConflictsStructure() {
        String prefix = "/propagationTechnique";
        String className = ConfigurationManager.getString(0, "preprocessing" + prefix + "/" + "revisionManager", "class");
        if (!className.equals(Tools.getRelativeClassNameOf(RevisionManager0.class))) {
            return true;
        }
        className = ConfigurationManager.getString(0, "search/valueHeuristic", "class");
        return !className.equals(Tools.getRelativeClassNameOf(RawLexico.class));
    }

    public UniversalConstraint(Problem problem, Variable[] involvedVariables, String universalPredicateExpression, String key, boolean mustBuildConflictsStructure) {
        super(problem, involvedVariables);
        this.universalPredicateExpression = universalPredicateExpression;
        if (key == null || !map.containsKey(key)) {
            this.manager = new EvaluationManager(universalPredicateExpression);
            this.manager.addFirstAssociatedConstraint(this);
            if (mustBuildConflictsStructure) {
                this.conflictsStructure = ConflictsStructure.build(this);
            }
            if (key != null) {
                map.put(key, this.manager);
            }
        } else {
            this.manager = map.get(key);
            this.manager.addAnotherAssociatedConstraint(this);
            this.conflictsStructure = this.manager.getFirstAssociatedConstraint().getConflictsStructure();
            if (this.conflictsStructure != null) {
                this.conflictsStructure.addAnotherAssociatedConstraint(this);
            }
        }
    }

    public UniversalConstraint(Problem problem, Variable[] involvedVariables, String universalPredicateExpression, String key) {
        this(problem, involvedVariables, universalPredicateExpression, key, UniversalConstraint.mustBuildConflictsStructure());
    }

    public UniversalConstraint(Problem problem, Variable[] involvedVariables, String localPredicateExpression) {
        this(problem, involvedVariables, UniversalConstraint.getUniversalPredicateExpressionOf(localPredicateExpression, involvedVariables), null);
    }

    public final boolean check(int[] values) {
        return this.manager.check(values);
    }

    public boolean checkTupleOfIndexes(int[] indexes) {
        if (this.cache == null) {
            return super.checkTupleOfIndexes(indexes);
        }
        byte b = this.cache.getEvaluationOf(indexes);
        if (b == 0) {
            boolean support = super.checkTupleOfIndexes(indexes);
            this.cache.setEvaluationOf(indexes, support);
            return support;
        }
        return b == 1;
    }

    public static int getPositionOfVariableWithName(String token, Variable[] involvedVariables) {
        int i = 0;
        while (i < involvedVariables.length) {
            if (involvedVariables[i].getName().equals(token)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getUniversalPredicateExpressionOf(String localPredicateExpression, Variable[] involvedVariables) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(localPredicateExpression);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int i = UniversalConstraint.getPositionOfVariableWithName(token, involvedVariables);
            sb.append(i == -1 ? token : XMLInstanceRepresentation.getParameterNameFor(i));
            if (!st.hasMoreTokens()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private String getLocalPredicateExpression() {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.universalPredicateExpression);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            sb.append(token.startsWith("X") ? this.involvedVariables[Integer.parseInt(token.substring("X".length()))] : token);
            if (!st.hasMoreTokens()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public String getPredicateExpression(int mode) {
        return mode == 0 ? this.getLocalPredicateExpression() : this.universalPredicateExpression;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        return "Universal Constraint";
    }
}

