/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.ternary;

import abscon.constants.Expr;
import abscon.constraints.ternary.TernaryConstraint;
import abscon.problem.Problem;
import abscon.problem.Variable;

public class IntervalConstraint
extends TernaryConstraint {
    private int value;

    public IntervalConstraint(Problem problem, Variable[] variables, int value) {
        super(problem, variables);
        this.value = value;
    }

    public final boolean check(int[] values) {
        return values[0] + this.value == Math.abs(values[1] - values[2]);
    }

    public Variable isSpecificIncoherent() {
        return this.isDefaultSpecificIncoherent();
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        if (variableNames.length != 3) {
            return null;
        }
        return Expr.equ(Expr.add(variableNames[0], constantNames[0]), Expr.abs(Expr.sub(variableNames[1], variableNames[2])));
    }

    public String[] getNamesOfConstants() {
        return new String[]{String.valueOf(this.value)};
    }
}

