/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.random;

import abscon.constraints.Constraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.tools.randomLists.ImplicitRandomList;
import java.util.Arrays;

public class RandomIntentionConstraint
extends Constraint {
    private ImplicitRandomList implicitRandomList;
    private byte tightness;
    private int[] requiredSupport;

    public RandomIntentionConstraint(Problem problem, Variable[] variables, byte tightness, int instanceNumber, String algorithm, int[] requiredSupport) {
        super(problem, variables);
        this.tightness = tightness;
        this.requiredSupport = requiredSupport != null ? (int[])requiredSupport.clone() : null;
        this.implicitRandomList = new ImplicitRandomList(problem.getNbCollectedConstraints(), instanceNumber, variables.length, algorithm);
    }

    public RandomIntentionConstraint(Problem problem, Variable[] variables, byte tightness, int instanceNumber, String algorithm) {
        this(problem, variables, tightness, instanceNumber, algorithm, null);
    }

    protected final boolean check(int[] tupleOfValue) {
        if (Arrays.equals(this.requiredSupport, tupleOfValue)) {
            return true;
        }
        byte d = this.implicitRandomList.getRandomValueFor(tupleOfValue);
        return d >= this.tightness;
    }
}

