/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.random;

import abscon.constraints.extension.ExtensionConstraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.tools.randomLists.CoarseProportionRandomListGenerator;
import abscon.tools.randomLists.ProbabilityRandomListGenerator;
import abscon.tools.randomLists.RandomListGenerator;

public final class RandomExtensionConstraint
extends ExtensionConstraint {
    public RandomExtensionConstraint(Problem problem, Variable[] involvedVariables, int nbTuples, long seed, int type, int[] requiredSupport, boolean supports) {
        super(problem, involvedVariables);
        int[] nbValues = new int[involvedVariables.length];
        int i = 0;
        while (i < nbValues.length) {
            nbValues[i] = involvedVariables[i].getDomain().getCurrentSize();
            ++i;
        }
        CoarseProportionRandomListGenerator r = new CoarseProportionRandomListGenerator(nbValues, seed);
        int[][] tuples = r.selectTuples(nbTuples, type, false, true, requiredSupport, supports);
        this.setSupports(tuples, supports, null);
    }

    public RandomExtensionConstraint(Problem problem, Variable[] involvedVariables, double nbUnallowedTuples, long seed, int type, int[] requiredSupport) {
        super(problem, involvedVariables);
        int[] nbValues = new int[involvedVariables.length];
        int i = 0;
        while (i < nbValues.length) {
            nbValues[i] = involvedVariables[i].getDomain().getCurrentSize();
            ++i;
        }
        double nbAllowedTuples = RandomListGenerator.computeNbArrangementsFrom(nbValues) - nbUnallowedTuples;
        if (nbAllowedTuples > 2.147483647E9 && nbUnallowedTuples > 2.147483647E9) {
            throw new IllegalArgumentException("The number of allowed and unallowed tuples is greater than Interger.MAX_INT");
        }
        int nbTuples = (int)Math.min(nbAllowedTuples, nbUnallowedTuples);
        CoarseProportionRandomListGenerator r = new CoarseProportionRandomListGenerator(nbValues, seed);
        int[][] tuples = r.selectTuples(nbTuples, type, false, true, requiredSupport, nbAllowedTuples < nbUnallowedTuples);
        this.setSupports(tuples, (double)tuples.length < nbUnallowedTuples, null);
    }

    public RandomExtensionConstraint(Problem problem, Variable[] variables, long nbUnallowedTuples, long seed, int type) {
        this(problem, variables, nbUnallowedTuples, seed, type, null);
    }

    public RandomExtensionConstraint(Problem problem, Variable[] variables, double tightness, long seed, int[] requiredSupport) {
        super(problem, variables);
        int nbValues = variables[0].getDomain().getMaximumSize();
        int tupleLength = variables.length;
        double selectionLimit = Math.min(tightness, 1.0 - tightness);
        ProbabilityRandomListGenerator r = new ProbabilityRandomListGenerator(nbValues, tupleLength, seed);
        int[][] tuples = r.selectTuples(selectionLimit, true, requiredSupport, tightness > 0.5);
        this.setSupports(tuples, tightness > 0.5, null);
    }

    public RandomExtensionConstraint(Problem problem, Variable[] variables, double tightness, long seed) {
        this(problem, variables, tightness, seed, null);
    }
}

