/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.global;

import abscon.constants.Expr;
import abscon.constraints.global.AllCompatible;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;

public class AllOrdered
extends AllCompatible {
    public AllOrdered(Problem problem, Variable[] variables) {
        super(problem, variables);
    }

    protected boolean isCompatible(Variable variable0, int value0, Variable variable1, int value1) {
        return value0 <= value1;
    }

    public final boolean check(int[] values) {
        int i = 0;
        while (i < values.length - 1) {
            if (!this.isCompatible(this.involvedVariables[i], values[i], this.involvedVariables[i + 1], values[i + 1])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Variable tryRemovalsFrom(Domain singletonDomain) {
        Variable singletonVariable = singletonDomain.getVariable();
        int singletonValue = singletonDomain.getUniqueValue();
        int singletonVariablePosition = this.getPositionOf(singletonVariable);
        Variable futureVariable = this.getFirstFutureVariable();
        while (futureVariable != null) {
            Domain futureDomain = futureVariable.getDomain();
            int futureVariablePosition = this.getPositionOf(futureVariable);
            if (futureDomain != singletonDomain) {
                Variable v;
                int sizeBefore = futureDomain.getCurrentSize();
                int index = futureDomain.getFirstValidIndex();
                while (index != -1) {
                    int futureValue = futureDomain.toValue(index);
                    if (futureVariablePosition < singletonVariablePosition) {
                        if (!this.isCompatible(futureVariable, futureValue, singletonVariable, singletonValue)) {
                            futureDomain.removeElementAt(index, this.involvedVariables);
                        }
                    } else if (!this.isCompatible(singletonVariable, singletonValue, futureVariable, futureValue)) {
                        futureDomain.removeElementAt(index, this.involvedVariables);
                    }
                    index = futureDomain.getNextValidIndexAfter(index);
                }
                if (futureDomain.getCurrentSize() == 0) {
                    return futureVariable;
                }
                if (futureDomain.getCurrentSize() == 1 && futureDomain.getCurrentSize() != sizeBefore && (v = this.tryRemovalsFrom(futureDomain)) != null) {
                    return v;
                }
            }
            futureVariable = this.getNextFutureVariableAfter(futureVariable);
        }
        return null;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        return Expr.different(variableNames);
    }
}

