/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension.structures;

import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.domains.Domain;
import abscon.tools.math.LexicographicComparator;
import java.util.Arrays;

public class Tuples
extends ExtensionStructure {
    protected int[][] tuples;
    protected boolean supportOriented;
    public LexicographicComparator comparator;

    public int[][] getTuples() {
        return this.tuples;
    }

    protected void setSupports(int[][] tuples, boolean supportOriented, LexicographicComparator comparator) {
        Constraint constraint = this.getFirstAssociatedConstraint();
        if (tuples.length == 0) {
            this.tuples = tuples;
        } else if (constraint.getIndexValueSimilarity()) {
            this.tuples = new int[tuples.length][tuples[0].length];
            int i = 0;
            while (i < tuples.length) {
                int j = 0;
                while (j < tuples[i].length) {
                    this.tuples[i][j] = tuples[i][j];
                    ++j;
                }
                ++i;
            }
        } else {
            this.tuples = new int[tuples.length][tuples[0].length];
            int j = 0;
            while (j < tuples[0].length) {
                Domain domain = constraint.getInvolvedVariable(j).getDomain();
                int i = 0;
                while (i < tuples.length) {
                    this.tuples[i][j] = domain.toIndex(tuples[i][j]);
                    ++i;
                }
                ++j;
            }
            constraint.setIndexValueSimilarity(true);
        }
        this.supportOriented = supportOriented;
        this.comparator = comparator;
        Arrays.sort(this.tuples, comparator);
    }

    public void setSupports(int[][] tuples, boolean supportOriented) {
        this.setSupports(tuples, supportOriented, new LexicographicComparator());
    }

    public Tuples(Constraint constraint) {
        super(constraint);
    }

    public boolean check(int[] indexes) {
        return Arrays.binarySearch(this.tuples, indexes, this.comparator) >= 0 == this.supportOriented;
    }

    public boolean removeTuple(int[] tuple) {
        throw new MissingImplementationException();
    }

    public String getStringListOfTuples() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.tuples.length) {
            if (i != 0) {
                sb.append("|");
            }
            int j = 0;
            while (j < this.tuples[i].length - 1) {
                sb.append(this.tuples[i][j]);
                sb.append(" ");
                ++j;
            }
            sb.append(this.tuples[i][this.tuples[i].length - 1]);
            ++i;
        }
        sb.append("|");
        return sb.append("#" + (this.supportOriented ? "supports" : "conflicts") + this.tuples.length).toString();
    }
}

