/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension.structures;

import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.Tuples;
import abscon.tools.math.LexicographicComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Supports
extends Tuples {
    protected int[][][][] positionsOfSupports;

    public int[][] getSupportsOf(int position, int index) {
        return this.positionsOfSupports[position][index];
    }

    public int getNbSupports(int position, int index) {
        return this.positionsOfSupports[position][index].length;
    }

    public int[] getFirstSupport(int position, int index) {
        int[][] positions = this.positionsOfSupports[position][index];
        if (positions.length == 0) {
            return null;
        }
        return positions[0];
    }

    public int[] getNextSupport(int position, int index, int[] current) {
        int[][] positions = this.positionsOfSupports[position][index];
        int res = Arrays.binarySearch(positions, current, this.comparator);
        if (res >= 0) {
            return current;
        }
        int point = -res - 1;
        if (point == positions.length) {
            return null;
        }
        return positions[point];
    }

    protected void buildStructures() {
        int j;
        Constraint constraint = this.getFirstAssociatedConstraint();
        List[][] tmp = new List[constraint.getNbInvolvedVariables()][];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = new List[constraint.getInvolvedVariable(i).getDomain().getMaximumSize()];
            j = 0;
            while (j < tmp[i].length) {
                tmp[i][j] = new ArrayList();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.tuples.length) {
            j = 0;
            while (j < this.tuples[i].length) {
                tmp[j][this.tuples[i][j]].add(this.tuples[i]);
                ++j;
            }
            ++i;
        }
        this.positionsOfSupports = new int[constraint.getNbInvolvedVariables()][][][];
        i = 0;
        while (i < this.positionsOfSupports.length) {
            this.positionsOfSupports[i] = new int[constraint.getInvolvedVariable(i).getDomain().getMaximumSize()][][];
            j = 0;
            while (j < this.positionsOfSupports[i].length) {
                this.positionsOfSupports[i][j] = (int[][])tmp[i][j].toArray((T[])new int[tmp[i][j].size()][]);
                ++j;
            }
            ++i;
        }
    }

    public void setSupports(int[][] tuples, boolean allowedTuples, LexicographicComparator comparator) {
        if (!allowedTuples) {
            throw new IllegalArgumentException();
        }
        super.setSupports(tuples, allowedTuples, comparator);
        this.buildStructures();
        assert (this.controlOrder());
    }

    public Supports(Constraint constraint) {
        super(constraint);
    }

    public void displayExhaustively() {
        int i = 0;
        while (i < this.positionsOfSupports.length) {
            System.out.println("Variable " + this.getFirstAssociatedConstraint().getInvolvedVariable(i));
            int j = 0;
            while (j < this.positionsOfSupports[i].length) {
                System.out.print("  " + j + " :");
                int k = 0;
                while (k < this.positionsOfSupports[i][j].length) {
                    System.out.print(" (");
                    int l = 0;
                    while (l < this.positionsOfSupports[i][j][k].length) {
                        System.out.print(String.valueOf(this.positionsOfSupports[i][j][k][l]) + (l < this.positionsOfSupports[i][j][k].length - 1 ? "," : ")"));
                        ++l;
                    }
                    ++k;
                }
                System.out.println();
                ++j;
            }
            ++i;
        }
    }

    protected boolean controlOrder() {
        int i = 0;
        while (i < this.positionsOfSupports.length) {
            int j = 0;
            while (j < this.positionsOfSupports[i].length) {
                int k = 0;
                while (k < this.positionsOfSupports[i][j].length - 1) {
                    if (this.comparator.compare(this.positionsOfSupports[i][j][k], this.positionsOfSupports[i][j][k + 1]) > 0) {
                        return false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

