/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension.structures;

import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.domains.Domain;

public class Matrix3D
extends ExtensionStructure {
    protected boolean[][][] supports;

    public void setSupports(int[][] tuples, boolean allowedTuples) {
        int n;
        int n2;
        Constraint constraint = this.getFirstAssociatedConstraint();
        Domain domain0 = constraint.getInvolvedVariable(0).getDomain();
        Domain domain1 = constraint.getInvolvedVariable(1).getDomain();
        Domain domain2 = constraint.getInvolvedVariable(2).getDomain();
        this.supports = new boolean[domain0.getMaximumSize()][domain1.getMaximumSize()][domain2.getMaximumSize()];
        if (!allowedTuples) {
            int i = 0;
            while (i < this.supports.length) {
                int j = 0;
                while (j < this.supports[i].length) {
                    int k = 0;
                    while (k < this.supports[i][j].length) {
                        this.supports[i][j][k] = true;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (constraint.getIndexValueSimilarity()) {
            int[][] nArray = tuples;
            n2 = 0;
            n = nArray.length;
            while (n2 < n) {
                int[] tuple = nArray[n2];
                this.supports[tuple[0]][tuple[1]][tuple[2]] = allowedTuples;
                ++n2;
            }
        } else {
            int[][] nArray = tuples;
            n2 = 0;
            n = nArray.length;
            while (n2 < n) {
                int[] tuple = nArray[n2];
                this.supports[domain0.toIndex((int)tuple[0])][domain1.toIndex((int)tuple[1])][domain2.toIndex((int)tuple[2])] = allowedTuples;
                ++n2;
            }
            constraint.setIndexValueSimilarity(true);
        }
    }

    public Matrix3D(Constraint constraint) {
        super(constraint);
        assert (constraint.getArity() == 3);
    }

    public final boolean check(int[] tuple) {
        return this.supports[tuple[0]][tuple[1]][tuple[2]];
    }

    public boolean removeTuple(int[] tuple) {
        if (this.isSharedStructure()) {
            throw new IncompatiblePropertiesException();
        }
        int index0 = tuple[0];
        int index1 = tuple[1];
        int index2 = tuple[2];
        if (!this.supports[index0][index1][index2]) {
            return false;
        }
        this.supports[index0][index1][index2] = false;
        ++this.nbTuplesRemoved;
        return true;
    }
}

