/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension.structures;

import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.domains.Domain;

public class Matrix2D
extends ExtensionStructure {
    protected boolean[][] supports;

    public void setSupports(int[][] tuples, boolean allowedTuples) {
        int n;
        Constraint constraint = this.getFirstAssociatedConstraint();
        Domain domain0 = constraint.getInvolvedVariable(0).getDomain();
        Domain domain1 = constraint.getInvolvedVariable(1).getDomain();
        this.supports = new boolean[domain0.getMaximumSize()][domain1.getMaximumSize()];
        if (!allowedTuples) {
            int i = 0;
            while (i < this.supports.length) {
                int j = 0;
                while (j < this.supports[i].length) {
                    this.supports[i][j] = true;
                    ++j;
                }
                ++i;
            }
        }
        if (constraint.getIndexValueSimilarity()) {
            int[][] nArray = tuples;
            n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int[] tuple = nArray[n];
                this.supports[tuple[0]][tuple[1]] = allowedTuples;
                ++n;
            }
        } else {
            int[][] nArray = tuples;
            n = 0;
            int n3 = nArray.length;
            while (n < n3) {
                int[] tuple = nArray[n];
                this.supports[domain0.toIndex((int)tuple[0])][domain1.toIndex((int)tuple[1])] = allowedTuples;
                ++n;
            }
            constraint.setIndexValueSimilarity(true);
        }
    }

    public Matrix2D(Constraint constraint) {
        super(constraint);
        assert (constraint.getArity() == 2);
    }

    public final boolean check(int[] tuple) {
        return this.supports[tuple[0]][tuple[1]];
    }

    public boolean removeTuple(int[] tuple) {
        if (this.isSharedStructure()) {
            throw new IncompatiblePropertiesException();
        }
        int index0 = tuple[0];
        int index1 = tuple[1];
        if (!this.supports[index0][index1]) {
            return false;
        }
        this.supports[index0][index1] = false;
        ++this.nbTuplesRemoved;
        return true;
    }

    public void displayExhaustively() {
        System.out.println("Matrix2D of " + this.getFirstAssociatedConstraint());
        int i = 0;
        while (i < this.supports.length) {
            int j = 0;
            while (j < this.supports[i].length) {
                System.out.print(this.supports[i][j] ? "1" : "0");
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }
}

