/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension;

import abscon.constraints.extension.ExtensionConstraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.constraints.extension.structures.Optim2D;
import abscon.constraints.extension.structures.Supports2D;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;

public final class ExtensionConstraintVABinary
extends ExtensionConstraint {
    protected ExtensionStructure buildExtensionStructure() {
        boolean optim = ConfigurationManager.getBoolean(this.problem.getLevelInResolution(), "problem/extension", "optim2D");
        return optim ? new Optim2D(this) : new Supports2D(this);
    }

    public void setSupports(int[][] tuples, boolean allowedTuples, String key) {
        if (this.involvedVariables.length != 2 || !allowedTuples) {
            throw new IncompatiblePropertiesException();
        }
        super.setSupports(tuples, allowedTuples, key);
    }

    public ExtensionConstraintVABinary(Problem problem, Variable[] variables) {
        super(problem, variables);
    }

    private final boolean seekSupportVS(int variablePosition, int index, int[] tuple, boolean another) {
        int current;
        int brotherPosition = variablePosition == 0 ? 1 : 0;
        Elements brotherElements = this.involvedVariables[brotherPosition].getDomain().getElements();
        int n = current = another ? brotherElements.getNextPresent(tuple[brotherPosition]) : brotherElements.getFirstPresent();
        while (true) {
            if (current == -1) {
                return false;
            }
            this.problem.incrementNbConstraintChecks();
            int c = this.extensionStructure.getNextBinarySupport(variablePosition, index, current);
            if (c == current) break;
            if (c == -1) {
                return false;
            }
            if (brotherElements.isPresent(c)) {
                current = c;
                break;
            }
            current = brotherElements.getNextPresent(c);
        }
        tuple[brotherPosition] = current;
        return true;
    }

    public final boolean seekSupport(int variablePosition, int index, int[] tuple) {
        tuple[variablePosition] = index;
        return this.seekSupportVS(variablePosition, index, tuple, false);
    }

    public final boolean seekAnotherSupport(int variablePosition, int index, int[] tuple) {
        return this.seekSupportVS(variablePosition, index, tuple, true);
    }
}

