/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension;

import abscon.constraints.extension.ExtensionConstraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.constraints.extension.structures.Supports;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.tools.absconParameters.ConfigurationManager;
import java.util.Arrays;

public final class ExtensionConstraintA
extends ExtensionConstraint {
    private int type;
    private boolean optim;
    private Supports supps;

    protected ExtensionStructure buildExtensionStructure() {
        this.type = ConfigurationManager.getInt(this.problem.getLevelInResolution(), "problem/extension", "type");
        this.optim = ConfigurationManager.getBoolean(this.problem.getLevelInResolution(), "problem/extension", "optim2D");
        this.supps = new Supports(this);
        return this.supps;
    }

    private void manageSharing() {
        ExtensionConstraintA constraint = (ExtensionConstraintA)this.extensionStructure.getFirstAssociatedConstraint();
        if (constraint != this) {
            this.type = constraint.type;
            this.optim = constraint.optim;
            this.supps = constraint.supps;
        }
    }

    public void setSupports(int[][] tuples, boolean allowedTuples, String key) {
        if (!allowedTuples) {
            throw new IncompatiblePropertiesException();
        }
        super.setSupports(tuples, allowedTuples, key);
        this.manageSharing();
    }

    public void setSupports(String canonicalPredicate, String key) {
        super.setSupports(canonicalPredicate, key);
        this.manageSharing();
    }

    public ExtensionConstraintA(Problem problem, Variable[] variables) {
        super(problem, variables);
    }

    private int computeStartingPosition(int[][] supports, int[] current) {
        int res = Arrays.binarySearch(supports, current, this.supps.comparator);
        if (res >= 0) {
            return res;
        }
        return -res - 1;
    }

    private final boolean seekSupportS(int variablePosition, int index, int[] tuple, boolean another) {
        int[][] supports = this.supps.getSupportsOf(variablePosition, index);
        int start = another ? this.computeStartingPosition(supports, tuple) : 0;
        int[] tmp = this.optim ? this.tupleManager.getLastTupleWith(variablePosition, index) : null;
        int i = start;
        while (i < supports.length) {
            this.problem.incrementNbConstraintChecks();
            if (this.optim && this.supps.comparator.compare(supports[i], tmp) > 0) {
                return false;
            }
            if (this.checkValidityOf(supports[i])) {
                int j = 0;
                while (j < tuple.length) {
                    tuple[j] = supports[i][j];
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean seekSupport(int variablePosition, int index, int[] tuple) {
        tuple[variablePosition] = index;
        if (this.type == 1 || this.domainManager.getDCurrentDomainSizeExcluding(variablePosition) > (double)this.supps.getNbSupports(variablePosition, index)) {
            return this.seekSupportS(variablePosition, index, tuple, false);
        }
        assert (this.type == 3);
        return super.seekSupport(variablePosition, index, tuple);
    }

    public final boolean seekAnotherSupport(int variablePosition, int index, int[] tuple) {
        if (this.type == 1 || this.domainManager.getDCurrentDomainSizeExcluding(variablePosition) > (double)this.supps.getNbSupports(variablePosition, index)) {
            return this.seekSupportS(variablePosition, index, tuple, true);
        }
        assert (this.type == 3);
        return super.seekAnotherSupport(variablePosition, index, tuple);
    }
}

