/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension;

import abscon.constraints.ConflictsStructure;
import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.Bits;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.constraints.extension.structures.Matrix2D;
import abscon.constraints.extension.structures.Matrix3D;
import abscon.constraints.extension.structures.Matrix4D;
import abscon.constraints.extension.structures.Tuples;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.tools.absconParameters.ConfigurationManager;
import java.util.HashMap;
import java.util.Map;

public class ExtensionConstraint
extends Constraint {
    public static final int MATRIX = 0;
    public static final int TUPLES = 1;
    public static final int AUTO = 2;
    public static final int LIMIT_AUTO = 500000;
    private static Map<String, ExtensionStructure> map = new HashMap<String, ExtensionStructure>();
    private static long nbResidues;
    protected ExtensionStructure extensionStructure;

    public static long getNbResidues() {
        return nbResidues;
    }

    public static void clear() {
        map.clear();
    }

    public ExtensionStructure getExtensionStructure() {
        return this.extensionStructure;
    }

    public int isSymmetric() {
        return this.extensionStructure.isSymmetric();
    }

    protected ExtensionStructure buildExtensionStructure() {
        boolean tooLarge;
        int validModel = ConfigurationManager.getInt(this.problem.getLevelInResolution(), "problem/extension", "validModel");
        if (validModel == 0) {
            if (this.involvedVariables.length == 2) {
                return new Bits(this);
            }
            if (this.involvedVariables.length == 3) {
                return new Matrix3D(this);
            }
            if (this.involvedVariables.length == 4) {
                return new Matrix4D(this);
            }
            return new Tuples(this);
        }
        if (validModel == 1) {
            return new Tuples(this);
        }
        long size = this.domainManager.getCurrentDomainSize();
        boolean bl = tooLarge = size == -1L || size > 500000L;
        if (tooLarge || this.involvedVariables.length >= 5) {
            return new Tuples(this);
        }
        if (this.involvedVariables.length == 2) {
            return new Matrix2D(this);
        }
        if (this.involvedVariables.length == 3) {
            return new Matrix3D(this);
        }
        assert (this.involvedVariables.length == 4);
        return new Matrix4D(this);
    }

    public void setSupports(int[][] tuples, boolean allowedTuples, String key) {
        if (key == null || !map.containsKey(key)) {
            this.extensionStructure = this.buildExtensionStructure();
            this.extensionStructure.setSupports(tuples, allowedTuples);
            this.conflictsStructure = ConflictsStructure.build(this, tuples, allowedTuples);
            if (key != null) {
                map.put(key, this.extensionStructure);
            }
        } else {
            this.extensionStructure = map.get(key);
            this.extensionStructure.addAnotherAssociatedConstraint(this);
            this.conflictsStructure = this.extensionStructure.getFirstAssociatedConstraint().getConflictsStructure();
            this.conflictsStructure.addAnotherAssociatedConstraint(this);
            this.indexValueSimilarity = this.extensionStructure.getFirstAssociatedConstraint().getIndexValueSimilarity();
        }
        if (this.extensionStructure instanceof Bits) {
            int size = this.involvedVariables[0].getDomain().getMaximumSize();
            if (size > 500) {
                nbResidues += (long)size;
            }
            if ((size = this.involvedVariables[1].getDomain().getMaximumSize()) > 500) {
                nbResidues += (long)size;
            }
        }
    }

    public void setSupports(String canonicalPredicate, String key) {
        assert (this.involvedVariables.length == 2);
        if (key == null || !map.containsKey(key)) {
            this.extensionStructure = new Bits(this);
            this.conflictsStructure = new ConflictsStructure(this);
            this.conflictsStructure.buildStructures();
            ((Bits)this.extensionStructure).setSupports(canonicalPredicate);
            this.conflictsStructure.fixNbMaxConflicts();
            if (key != null) {
                map.put(key, this.extensionStructure);
            }
        } else {
            this.extensionStructure = map.get(key);
            this.extensionStructure.addAnotherAssociatedConstraint(this);
            this.conflictsStructure = this.extensionStructure.getFirstAssociatedConstraint().getConflictsStructure();
            this.conflictsStructure.addAnotherAssociatedConstraint(this);
            this.indexValueSimilarity = this.extensionStructure.getFirstAssociatedConstraint().getIndexValueSimilarity();
        }
        if (this.extensionStructure instanceof Bits) {
            int size = this.involvedVariables[0].getDomain().getMaximumSize();
            if (size > 500) {
                nbResidues += (long)size;
            }
            if ((size = this.involvedVariables[1].getDomain().getMaximumSize()) > 500) {
                nbResidues += (long)size;
            }
        }
    }

    public ExtensionConstraint(Problem problem, Variable[] variables) {
        super(problem, variables);
    }

    public boolean removeTuple(int[] tuple) {
        if (this.extensionStructure.removeTuple(tuple)) {
            this.conflictsStructure.manageRemovedTuple(tuple);
            return true;
        }
        return false;
    }

    public final boolean check(int[] tuple) {
        return this.extensionStructure.check(tuple);
    }

    public boolean canBeDefinedByAPredicate() {
        return false;
    }

    private boolean isValidTuple(int[] tuple) {
        int i = 0;
        while (i < tuple.length) {
            if (!this.involvedVariables[i].getDomain().hasValue(tuple[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean controlTuples(int[][] tuples) {
        int i = 0;
        while (i < tuples.length) {
            if (!this.isValidTuple(tuples[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

