/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.binary;

import abscon.constants.Expr;
import abscon.constraints.binaryWithInteger.BinaryConstraintWithInteger;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;

public class QueenMoveConstraint
extends BinaryConstraintWithInteger {
    public QueenMoveConstraint(Problem problem, Variable[] variables, int value) {
        super(problem, variables, value);
    }

    private boolean isQueenMove(int value0, int value1) {
        if (value0 == value1) {
            return false;
        }
        return value0 % this.value == value1 % this.value || value0 / this.value == value1 / this.value || Math.abs(value0 % this.value - value1 % this.value) == Math.abs(value0 / this.value - value1 / this.value);
    }

    protected boolean check(int[] values) {
        return this.isQueenMove(values[0], values[1]);
    }

    protected Variable tryRemovalsFrom(Domain singletonDomain, Domain futureDomain) {
        int singletonValue = singletonDomain.getUniqueValue();
        int index = futureDomain.getFirstValidIndex();
        while (index != -1) {
            if (!this.isQueenMove(singletonValue, futureDomain.toValue(index))) {
                futureDomain.removeElementAt(index, this.involvedVariables);
            }
            index = futureDomain.getNextValidIndexAfter(index);
        }
        if (futureDomain.isEmpty()) {
            return futureDomain.getVariable();
        }
        return null;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        if (variableNames.length != 2 || constantNames.length != 1) {
            return null;
        }
        return Expr.function("QueenMove", variableNames[0], variableNames[1], constantNames[0]);
    }

    public String getPredicateDefinition() {
        String[] variableNames = this.getNamesOfVariables(2);
        String[] constantNames = this.getNamesOfConstants(2);
        String rowDistance = Expr.abs(Expr.sub(Expr.div(variableNames[0], constantNames[0]), Expr.div(variableNames[1], constantNames[0])));
        String columnDistance = Expr.abs(Expr.sub(Expr.mod(variableNames[0], constantNames[0]), Expr.mod(variableNames[1], constantNames[0])));
        String diff = Expr.not(Expr.equ(variableNames[0], variableNames[1]));
        String sameRow = Expr.equ(Expr.mod(variableNames[0], constantNames[0]), Expr.mod(variableNames[1], constantNames[0]));
        String sameColumn = Expr.equ(Expr.div(variableNames[0], constantNames[0]), Expr.div(variableNames[1], constantNames[0]));
        String sameDiagonal = Expr.equ(rowDistance, columnDistance);
        return Expr.and(diff, Expr.or(sameRow, sameColumn, sameDiagonal));
    }
}

