/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints;

import abscon.constraints.Constraint;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnitOptimal;

public class TupleManager {
    public static final int SUPPORT = 2;
    public static final int CANDIDATE = 1;
    public static final int NOTHING = 0;
    private Constraint constraint;
    private int arity;
    private Domain[] domains;
    private int[] localTuple;
    private boolean[] fixedIndexes;
    protected int[] currentTuple;
    private SupportUnitOptimal[] supportUnits;

    public TupleManager(Constraint constraint) {
        this.constraint = constraint;
        this.arity = constraint.getNbInvolvedVariables();
        this.domains = new Domain[this.arity];
        int i = 0;
        while (i < this.domains.length) {
            this.domains[i] = constraint.getInvolvedVariable(i).getDomain();
            ++i;
        }
        this.localTuple = new int[this.arity];
        this.fixedIndexes = new boolean[this.arity];
    }

    public int[] getCurrentTuple() {
        return this.currentTuple;
    }

    public void setCurrentTuple(int[] tuple) {
        this.currentTuple = tuple;
    }

    public int[] getLocalTuple() {
        return this.localTuple;
    }

    public void setSupportUnits(SupportUnitOptimal[] supportUnits) {
        this.supportUnits = supportUnits;
    }

    public void fixIndex(int position, int index) {
        this.currentTuple[position] = index;
        this.fixedIndexes[position] = true;
    }

    public int[] getLastTupleWith(int position, int index, int[] tuple) {
        assert (this.controlNotEmptyDomains());
        int i = 0;
        while (i < this.arity) {
            tuple[i] = i == position ? index : this.domains[i].getLastValidIndex();
            ++i;
        }
        return tuple;
    }

    public int[] getLastTupleWith(int position, int index) {
        return this.getLastTupleWith(position, index, this.localTuple);
    }

    public void setFirstTupleFromScratch(int[] tuple) {
        assert (this.controlNotEmptyDomains());
        this.currentTuple = tuple;
        int i = 0;
        while (i < this.arity) {
            tuple[i] = this.domains[i].getFirstValidIndex();
            this.fixedIndexes[i] = false;
            ++i;
        }
    }

    public void setFirstTupleFromScratch() {
        this.setFirstTupleFromScratch(this.localTuple);
    }

    public void setFirstTupleFromScratch(int[] tuple, int position, int index) {
        this.setFirstTupleFromScratch(tuple);
        this.fixIndex(position, index);
    }

    public void setFirstTupleFromScratch(int[] tuple, int position1, int index1, int position2, int index2) {
        this.setFirstTupleFromScratch(tuple);
        this.fixIndex(position1, index1);
        this.fixIndex(position2, index2);
    }

    public void setFirstTupleFromScratch(int[] tuple, int[] positions, int[] indexes, int nbElements) {
        this.setFirstTupleFromScratch(tuple);
        int i = 0;
        while (i < nbElements) {
            this.fixIndex(positions[i], indexes[i]);
            ++i;
        }
    }

    private int setNextTupleBefore(int frontier) {
        int i = frontier;
        while (i >= 0) {
            if (!this.fixedIndexes[i]) {
                int v = this.domains[i].getFirstValidIndexStrictlyGreaterThan(this.currentTuple[i]);
                if (v != -1) {
                    this.currentTuple[i] = v;
                    return i;
                }
                this.currentTuple[i] = this.domains[i].getFirstValidIndex();
            }
            --i;
        }
        return -1;
    }

    public final int setNextTuple() {
        return this.setNextTupleBefore(this.arity - 1);
    }

    private final int getFirstIncoherentPosition() {
        int i = 0;
        while (i < this.arity) {
            if (!this.domains[i].hasIndex(this.currentTuple[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setNextTupleAfter(int frontier) {
        int i = frontier;
        while (i < this.arity) {
            if (!this.fixedIndexes[i]) {
                this.currentTuple[i] = this.domains[i].getFirstValidIndex();
            }
            ++i;
        }
    }

    private int setNextTupleConsideringInvalidityAt(int position) {
        int modificationPosition = this.setNextTupleBefore(position);
        if (modificationPosition == -1) {
            return -1;
        }
        this.setNextTupleAfter(position + 1);
        return modificationPosition;
    }

    private int setNextTupleConsideringPotentialInvalidity() {
        int frontier = this.getFirstIncoherentPosition();
        if (frontier == -1) {
            return this.setNextTuple();
        }
        return this.setNextTupleConsideringInvalidityAt(frontier);
    }

    public final int setNextTupleStricltyGreaterThan(int[] tuple) {
        this.currentTuple = tuple;
        int i = 0;
        while (i < this.fixedIndexes.length) {
            this.fixedIndexes[i] = false;
            ++i;
        }
        return this.setNextTupleConsideringPotentialInvalidity();
    }

    public final int setNextTupleStrictlyGreaterThan(int[] tuple, int position, int index) {
        this.currentTuple = tuple;
        int i = 0;
        while (i < this.fixedIndexes.length) {
            this.fixedIndexes[i] = false;
            ++i;
        }
        this.fixIndex(position, index);
        return this.setNextTupleConsideringPotentialInvalidity();
    }

    private int copyAsMuchAsPossibleFrom(int beginning, int[] externTuple) {
        int i = beginning;
        while (i < this.currentTuple.length) {
            if (this.currentTuple[i] != externTuple[i]) {
                if (this.fixedIndexes[i]) {
                    return i;
                }
                this.currentTuple[i] = externTuple[i];
                if (!this.domains[i].hasIndex(externTuple[i])) {
                    return i;
                }
            }
            ++i;
        }
        return this.currentTuple.length;
    }

    public int seekCandidate(int frontier) {
        int k = frontier;
        while (k < this.currentTuple.length) {
            assert (this.constraint.checkValidityOf(this.currentTuple));
            if (!this.fixedIndexes[k] && this.supportUnits[k].isInitialized(this.currentTuple[k])) {
                int[] externTuple = this.supportUnits[k].getLastSupportOf(this.currentTuple[k]);
                int split = 0;
                while (split < this.currentTuple.length && this.currentTuple[split] == externTuple[split]) {
                    ++split;
                }
                if (split == this.currentTuple.length) {
                    return 2;
                }
                if (this.currentTuple[split] <= externTuple[split]) {
                    assert (split != k);
                    if (split < k) {
                        int firstModifiedPosition = this.setNextTupleConsideringInvalidityAt(k);
                        if (firstModifiedPosition == -1) {
                            return 0;
                        }
                        k = firstModifiedPosition - 1;
                    } else {
                        int end = this.copyAsMuchAsPossibleFrom(split, externTuple);
                        if (end == this.currentTuple.length) {
                            return 2;
                        }
                        assert (!this.fixedIndexes[end] || this.currentTuple[end] <= externTuple[end] || end != split);
                        if (this.fixedIndexes[end] && this.currentTuple[end] > externTuple[end]) {
                            this.setNextTupleAfter(end + 1);
                        } else {
                            int firstModifiedPosition = this.setNextTupleConsideringInvalidityAt(end);
                            if (firstModifiedPosition == -1) {
                                return 0;
                            }
                            if (firstModifiedPosition - 1 < k) {
                                k = firstModifiedPosition - 1;
                            }
                        }
                    }
                }
            }
            ++k;
        }
        return 1;
    }

    private boolean isThereATupleFromAssistantTuple(boolean allowed) {
        do {
            if (this.constraint.checkTupleOfIndexes(this.currentTuple) != allowed) continue;
            return true;
        } while (this.setNextTuple() != -1);
        return false;
    }

    protected void appendTupleTo(int[] tuple, StringBuffer sb) {
        if (this.constraint.getProblem().getResolution() != null && this.constraint.getProblem().getResolution().getVersionXCSP() == 1.1) {
            sb.append("(");
            int i = 0;
            while (i < tuple.length - 1) {
                sb.append(tuple[i]);
                sb.append(",");
                ++i;
            }
            sb.append(tuple[tuple.length - 1]);
            sb.append(")");
        } else {
            int i = 0;
            while (i < tuple.length - 1) {
                sb.append(tuple[i]);
                sb.append(" ");
                ++i;
            }
            sb.append(tuple[tuple.length - 1]);
        }
    }

    public String getStringListOfTuples(boolean allowed) {
        if (!this.controlNotEmptyDomains()) {
            return "";
        }
        int cpt = 0;
        StringBuffer sb = new StringBuffer();
        this.setFirstTupleFromScratch(this.getLocalTuple());
        boolean first = true;
        boolean validity = true;
        while (validity && this.isThereATupleFromAssistantTuple(allowed)) {
            ++cpt;
            if (!first) {
                sb.append(" ");
            } else {
                first = false;
            }
            this.appendTupleTo(this.constraint.toValues(this.currentTuple), sb);
            boolean bl = validity = this.setNextTuple() != -1;
        }
        sb.append("#" + cpt);
        return sb.toString();
    }

    private String dealWithConstraintWithNoMoreTuple(int[] tuple) {
        boolean noMoreTuple = false;
        int[] nArray = tuple;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int v = nArray[n];
            if (v == -1) {
                noMoreTuple = true;
            }
            ++n;
        }
        return noMoreTuple ? "#supports0" : null;
    }

    public String getStringListOfTuples() {
        boolean format2;
        boolean bl = format2 = this.constraint.getProblem().getResolution() == null || this.constraint.getProblem().getResolution().getVersionXCSP() == 2.0;
        if (this.constraint.tightness == -10.0) {
            StringBuffer sbSupports = new StringBuffer();
            StringBuffer sbConflicts = new StringBuffer();
            this.setFirstTupleFromScratch(this.getLocalTuple());
            String emptyRelation = this.dealWithConstraintWithNoMoreTuple(this.currentTuple);
            if (emptyRelation != null) {
                return emptyRelation;
            }
            int nbSupports = 0;
            int nbConflicts = 0;
            int recordMode = 0;
            int cpt = 0;
            do {
                boolean consistent;
                if ((consistent = this.constraint.checkTupleOfIndexes(this.currentTuple)) && recordMode != -1) {
                    this.appendTupleTo(this.constraint.toValues(this.currentTuple), sbSupports);
                    if (format2) {
                        sbSupports.append("|");
                    }
                    ++nbSupports;
                } else if (!consistent && recordMode != 1) {
                    this.appendTupleTo(this.constraint.toValues(this.currentTuple), sbConflicts);
                    if (format2) {
                        sbConflicts.append("|");
                    }
                    ++nbConflicts;
                }
                if (recordMode != 0 || ++cpt <= 100000) continue;
                recordMode = nbSupports <= nbConflicts ? 1 : -1;
            } while (this.setNextTuple() != -1);
            String tuples = nbSupports <= nbConflicts ? sbSupports.append("#supports" + nbSupports).toString() : sbConflicts.append("#conflicts" + nbConflicts).toString();
            return tuples;
        }
        boolean supports = this.constraint.tightness >= 0.5;
        StringBuffer sbTuples = new StringBuffer();
        this.setFirstTupleFromScratch(this.getLocalTuple());
        int nbTuples = 0;
        do {
            if (this.constraint.checkTupleOfIndexes(this.currentTuple) != supports) continue;
            this.appendTupleTo(this.constraint.toValues(this.currentTuple), sbTuples);
            if (format2) {
                sbTuples.append("|");
            }
            ++nbTuples;
        } while (this.setNextTuple() != -1);
        String tuples = sbTuples.append("#" + (supports ? "supports" : "conflicts") + nbTuples).toString();
        return tuples;
    }

    public void displayAllCandidatesFrom(int[] tuple) {
        int cpt = 0;
        if (this.setNextTupleStricltyGreaterThan(tuple) != -1) {
            // empty if block
        }
        boolean validity = true;
        while (validity && this.constraint.seekSupportCandidateFromAssistantTuple()) {
            ++cpt;
            System.out.print("(");
            int i = 0;
            while (i < tuple.length) {
                System.out.print(String.valueOf(tuple[i]) + ",");
                ++i;
            }
            System.out.print(") ");
            boolean bl = validity = this.setNextTuple() != -1;
        }
        System.out.println();
        System.out.println(" => constraint with " + cpt + " candidates");
    }

    private boolean controlNotEmptyDomains() {
        int i = 0;
        while (i < this.arity) {
            if (this.domains[i].getCurrentSize() == 0) {
                System.out.println("Domain " + this.domains[i] + " is empty");
                return false;
            }
            ++i;
        }
        return true;
    }
}

