/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints;

import abscon.constraints.Constraint;
import abscon.constraints.extension.ExtensionConstraint;
import abscon.constraints.extension.ExtensionConstraintA;
import abscon.constraints.extension.ExtensionConstraintABinary;
import abscon.constraints.extension.ExtensionConstraintV;
import abscon.constraints.extension.ExtensionConstraintVA;
import abscon.constraints.extension.Semantics;
import abscon.constraints.universal.UniversalConstraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.reflection.Reflector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintBuilder {
    private static Class[] classes;
    private static Method[] methods;
    private static Constructor[] constructors;

    public static int[] buildDomainValues(String stringOfValues) {
        String delimiters = " \n\r\t";
        StringTokenizer st = new StringTokenizer(stringOfValues, delimiters);
        if (st.countTokens() == 1) {
            int min = Integer.parseInt(st.nextToken(String.valueOf(delimiters) + ".."));
            int max = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : min;
            return new int[]{min, max, Integer.MAX_VALUE};
        }
        LinkedList<Integer> list = new LinkedList<Integer>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int position = token.indexOf("..");
            if (position == -1) {
                list.add(new Integer(token));
                continue;
            }
            int min = Integer.parseInt(token.substring(0, position));
            int max = Integer.parseInt(token.substring(position + "..".length()));
            int i = min;
            while (i <= max) {
                list.add(new Integer(i));
                ++i;
            }
        }
        int[] values = new int[list.size()];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            values[i++] = value;
        }
        return values;
    }

    public static int[][] buildTuples(int nbTuples, int arity, String s) {
        int[][] tuples = new int[nbTuples][arity];
        String delimiters = " |\n\r";
        StringTokenizer st = new StringTokenizer(s, delimiters);
        int i = 0;
        while (i < tuples.length) {
            int j = 0;
            while (j < arity) {
                tuples[i][j] = Integer.parseInt(st.nextToken());
                ++j;
            }
            ++i;
        }
        return tuples;
    }

    public static String[] extractFormalParameters(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int cpt = 0;
        String[] formalParameters = new String[st.countTokens() / 2];
        while (st.hasMoreTokens()) {
            st.nextToken();
            formalParameters[cpt++] = st.nextToken();
        }
        return formalParameters;
    }

    public static String buildPredicateExpression(String postfixPredicateExpression, String[] effectiveParameters) {
        String s = "";
        StringTokenizer st = new StringTokenizer(postfixPredicateExpression);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("X")) {
                token = effectiveParameters[Integer.parseInt(token.substring("X".length()))];
            }
            s = String.valueOf(s) + " " + token;
        }
        return s.trim();
    }

    public static Variable[] extractInvolvedVariablesFrom(String stringListOfVariables, Map<String, Variable> mapOfVariables) {
        StringTokenizer st = new StringTokenizer(stringListOfVariables, " ");
        Variable[] involvedVariables = new Variable[st.countTokens()];
        int i = 0;
        while (i < involvedVariables.length) {
            String token = st.nextToken();
            involvedVariables[i] = mapOfVariables.get(token);
            if (involvedVariables[i] == null) {
                return null;
            }
            ++i;
        }
        return involvedVariables;
    }

    public static String[] extractEffectiveParameters(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int cpt = 0;
        String[] effectiveParameters = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            effectiveParameters[cpt++] = st.nextToken();
        }
        return effectiveParameters;
    }

    public static Variable buildVariable(Problem problem, String name, int[] values) {
        if (values.length == 3 && values[2] == Integer.MAX_VALUE) {
            return new Variable(problem, name, values[0], values[1]);
        }
        return new Variable(problem, name, values);
    }

    private static String[] getVariableNamesOf(Variable[] variables) {
        String[] variableNames = new String[variables.length];
        int i = 0;
        while (i < variableNames.length) {
            variableNames[i] = variables[i].getName();
            ++i;
        }
        return variableNames;
    }

    private static String[] getConstantNamesFrom(String predicate) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(predicate, " )(");
        while (st.hasMoreTokens()) {
            boolean entier = true;
            int i = 0;
            try {
                i = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                entier = false;
            }
            if (!entier) continue;
            list.add(new String(String.valueOf(i)));
        }
        return list.toArray(new String[0]);
    }

    private static int[] transformToInt(String[] strings) {
        int[] t = new int[strings.length];
        int i = 0;
        while (i < t.length) {
            t[i] = Integer.parseInt(strings[i]);
            ++i;
        }
        return t;
    }

    private static Object[] buildObjectsForConstructor(Problem problem, Variable[] involvedVariables, String[] constantNames) {
        if (constantNames.length == 0) {
            return new Object[]{problem, involvedVariables};
        }
        if (constantNames.length == 1) {
            return new Object[]{problem, involvedVariables, Integer.valueOf(constantNames[0])};
        }
        if (constantNames.length == 2) {
            return new Object[]{problem, involvedVariables, Integer.valueOf(constantNames[0]), Integer.valueOf(constantNames[1])};
        }
        return new Object[]{problem, involvedVariables, ConstraintBuilder.transformToInt(constantNames)};
    }

    public static Constraint buildConstraintInIntention(Problem problem, Variable[] involvedVariables, String predicateExpression) {
        if (classes == null) {
            classes = Reflector.searchClassesInheritingFrom(Constraint.class, 1, 1024);
            methods = Reflector.searchMethods(classes, "getPredicateExpression", 8);
            constructors = Reflector.searchFirstConstructors(classes, 1);
        }
        String[] variableNames = ConstraintBuilder.getVariableNamesOf(involvedVariables);
        String[] constantNames = ConstraintBuilder.getConstantNamesFrom(predicateExpression);
        try {
            int i = 0;
            while (i < classes.length) {
                if (methods[i] != null) {
                    String s = "";
                    try {
                        s = (String)methods[i].invoke(null, variableNames, constantNames);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (predicateExpression.equals(s)) {
                        Object[] objects = ConstraintBuilder.buildObjectsForConstructor(problem, involvedVariables, constantNames);
                        return (Constraint)constructors[i].newInstance(objects);
                    }
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException se = e;
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static ExtensionConstraint buildExtensionConstraint(Problem problem, Variable[] involvedVariables, boolean supports) {
        int type = ConfigurationManager.getInt(problem.getLevelInResolution(), "problem/extension", "type");
        if (type == 0 || !supports) {
            return new ExtensionConstraintV(problem, involvedVariables);
        }
        if (type == 1 || type == 3) {
            return involvedVariables.length == 2 ? new ExtensionConstraintABinary(problem, involvedVariables) : new ExtensionConstraintA(problem, involvedVariables);
        }
        assert (type == 2);
        return involvedVariables.length == 2 ? new ExtensionConstraintV(problem, involvedVariables) : new ExtensionConstraintVA(problem, involvedVariables);
    }

    public static ExtensionConstraint buildConstraintInExtension(Problem problem, Variable[] involvedVariables, int[][] tuples, Semantics semantics, String key) {
        if (semantics == Semantics.SOFT) {
            return null;
        }
        boolean supports = semantics == Semantics.SUPPORTS;
        ExtensionConstraint constraint = ConstraintBuilder.buildExtensionConstraint(problem, involvedVariables, supports);
        constraint.setSupports(tuples, supports, key);
        return constraint;
    }

    public static Constraint buildUniversalConstraint(Problem problem, Variable[] involvedVariables, String predicateExpression) {
        return new UniversalConstraint(problem, involvedVariables, predicateExpression);
    }
}

