/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints;

import abscon.constraints.Constraint;
import abscon.constraints.TupleManager;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import java.util.LinkedList;
import java.util.List;

public final class ConflictsStructure {
    public static final int LIMIT_DOMAIN = 100000;
    protected List<Constraint> list = new LinkedList<Constraint>();
    private int[] nbMaxConflicts;
    private int[][] nbConflicts;

    public Constraint getFirstAssociatedConstraint() {
        return this.list.get(0);
    }

    private void addAFirstAssociatedConstraint(Constraint constraint) {
        assert (this.list.size() == 0);
        this.list.add(constraint);
        constraint.getProblem().incrementNbConflictsStructures();
    }

    public void addAnotherAssociatedConstraint(Constraint constraint) {
        assert (this.list.size() > 0);
        this.list.add(constraint);
        constraint.getProblem().incrementNbSharedConflictstructures();
    }

    public boolean isSharedStructure() {
        return this.list.size() > 1;
    }

    public int[][] getNbConflicts() {
        return this.nbConflicts;
    }

    public int[] getNbConflicts(int position) {
        return this.nbConflicts[position];
    }

    public int getNbInitialConflictsFor(int position, int index) {
        return this.nbConflicts[position][index];
    }

    public int getNbMaxConflictsFor(int variablePosition) {
        return this.nbMaxConflicts[variablePosition];
    }

    public ConflictsStructure(Constraint constraint) {
        this.addAFirstAssociatedConstraint(constraint);
    }

    public void buildStructures() {
        assert (this.list.size() == 1);
        Constraint constraint = this.getFirstAssociatedConstraint();
        this.nbMaxConflicts = new int[constraint.getNbInvolvedVariables()];
        this.nbConflicts = new int[constraint.getNbInvolvedVariables()][];
        int i = 0;
        while (i < this.nbConflicts.length) {
            this.nbConflicts[i] = new int[constraint.getInvolvedVariable(i).getDomain().getMaximumSize()];
            ++i;
        }
    }

    public void fixNbMaxConflicts() {
        int i = 0;
        while (i < this.nbMaxConflicts.length) {
            int max = -1;
            int j = 0;
            while (j < this.nbConflicts[i].length) {
                if (this.nbConflicts[i][j] > max) {
                    max = this.nbConflicts[i][j];
                }
                ++j;
            }
            this.nbMaxConflicts[i] = max;
            ++i;
        }
    }

    private boolean initializeFrom(int[][] tuples, boolean allowedTuples) {
        long sizeL;
        assert (this.list.size() == 1);
        Constraint constraint = this.getFirstAssociatedConstraint();
        if (allowedTuples && ((sizeL = constraint.getDomainManager().getCurrentDomainSize()) == -1L || (long)((int)sizeL) != sizeL)) {
            return false;
        }
        this.buildStructures();
        int i = 0;
        while (i < tuples.length) {
            int j = 0;
            while (j < tuples[i].length) {
                int[] nArray = this.nbConflicts[j];
                int n = constraint.getInvolvedVariable(j).getDomain().toIndex(tuples[i][j]);
                nArray[n] = nArray[n] + 1;
                ++j;
            }
            ++i;
        }
        if (allowedTuples) {
            i = 0;
            while (i < this.nbConflicts.length) {
                int size = (int)constraint.getDomainManager().getCurrentDomainSizeExcluding(i);
                int j = 0;
                while (j < this.nbConflicts[i].length) {
                    this.nbConflicts[i][j] = size - this.nbConflicts[i][j];
                    ++j;
                }
                ++i;
            }
        }
        this.fixNbMaxConflicts();
        return true;
    }

    public static ConflictsStructure build(Constraint constraint, int[][] tuples, boolean allowedTuples) {
        ConflictsStructure conflictsStructure = new ConflictsStructure(constraint);
        boolean initialized = conflictsStructure.initializeFrom(tuples, allowedTuples);
        if (!initialized) {
            constraint.getProblem().decrementNbConflictsStructures();
            constraint.getProblem().incrementNbUnbuiltConflictsStructures();
            return null;
        }
        return conflictsStructure;
    }

    private boolean usePrecomputedNumberOfConflicts(Constraint constraint) {
        int firstIndex;
        Variable firstVariable = constraint.getInvolvedVariable(0);
        return constraint.getNbMaxConflictsUpperBoundFor(firstVariable, firstIndex = firstVariable.getDomain().getFirstValidIndex()) != -10;
    }

    private boolean initialize() {
        long sizeL;
        assert (this.list.size() == 1);
        Constraint constraint = this.getFirstAssociatedConstraint();
        if (constraint.getArity() > 2 && ((sizeL = constraint.getDomainManager().getCurrentDomainSize()) == -1L || sizeL > 100000L)) {
            return false;
        }
        this.buildStructures();
        if (this.usePrecomputedNumberOfConflicts(constraint)) {
            int i = 0;
            while (i < this.nbConflicts.length) {
                Variable variable = constraint.getInvolvedVariable(i);
                int j = 0;
                while (j < this.nbConflicts[i].length) {
                    this.nbConflicts[i][j] = constraint.getNbMaxConflictsUpperBoundFor(variable, j);
                    ++j;
                }
                ++i;
            }
        } else {
            TupleManager assistant = constraint.getTupleManager();
            int[] tuple = assistant.getLocalTuple();
            int cpt = 0;
            if (constraint.getArity() == 2) {
                Domain domain0 = constraint.getInvolvedVariable(0).getDomain();
                Domain domain1 = constraint.getInvolvedVariable(1).getDomain();
                int i = 0;
                while (i < domain0.getMaximumSize()) {
                    tuple[0] = domain0.toValue(i);
                    int j = 0;
                    while (j < domain1.getMaximumSize()) {
                        tuple[1] = domain1.toValue(j);
                        ++cpt;
                        if (!constraint.check(tuple)) {
                            int[] nArray = this.nbConflicts[0];
                            int n = i;
                            nArray[n] = nArray[n] + 1;
                            int[] nArray2 = this.nbConflicts[1];
                            int n2 = j;
                            nArray2[n2] = nArray2[n2] + 1;
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                assistant.setFirstTupleFromScratch(tuple);
                do {
                    ++cpt;
                    if (constraint.checkTupleOfIndexes(tuple)) continue;
                    int i = 0;
                    while (i < tuple.length) {
                        int[] nArray = this.nbConflicts[i];
                        int n = tuple[i];
                        nArray[n] = nArray[n] + 1;
                        ++i;
                    }
                } while (assistant.setNextTuple() != -1);
            }
            constraint.getProblem().incrementNbConvertConstraintsChecksOf(cpt);
        }
        this.fixNbMaxConflicts();
        return true;
    }

    public static ConflictsStructure build(Constraint constraint) {
        ConflictsStructure conflictsStructure = new ConflictsStructure(constraint);
        boolean initialized = conflictsStructure.initialize();
        if (!initialized) {
            constraint.getProblem().decrementNbConflictsStructures();
            constraint.getProblem().incrementNbUnbuiltConflictsStructures();
            return null;
        }
        return conflictsStructure;
    }

    public void manageRemovedTuple(int[] tuple) {
    }

    public void display() {
        if (this.nbConflicts == null) {
            return;
        }
        int i = 0;
        while (i < this.nbConflicts.length) {
            System.out.print("      nbConflicts at " + i + " =");
            int j = 0;
            while (j < this.nbConflicts[i].length) {
                System.out.print(String.valueOf(this.nbConflicts[i][j]) + " ");
                ++j;
            }
            System.out.println();
            System.out.println("      max nb Conflicts = " + this.nbMaxConflicts[i]);
            System.out.println();
            ++i;
        }
    }
}

