/*
 * Decompiled with CFR 0.152.
 */
package abscon.abstraction;

import abscon.abstraction.AbstractionManager;
import abscon.abstraction.Concretizator;
import abscon.constraints.Constraint;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.domains.Domain;

public abstract class ApproximationRelation {
    protected AbstractionManager abstractionManager;
    protected int id;
    protected Domain[] concreteDomains;
    protected Domain[] abstractDomains;
    protected Constraint guidingConstraint;

    public AbstractionManager getManager() {
        return this.abstractionManager;
    }

    public int getId() {
        return this.id;
    }

    protected Domain[] getConcreteDomains() {
        return this.concreteDomains;
    }

    protected Domain[] getAbstractDomains() {
        return this.abstractDomains;
    }

    protected Domain getConcreteDomain(int i) {
        return this.concreteDomains[i];
    }

    protected Domain getAbstractDomain(int i) {
        return this.abstractDomains[i];
    }

    public Constraint getGuidingConstraint() {
        return this.guidingConstraint;
    }

    void setId(int id) {
        this.id = id;
    }

    public void setGuidingConstraint(Constraint guidingConstraint) {
        this.guidingConstraint = guidingConstraint;
    }

    protected ApproximationRelation(AbstractionManager manager, Domain[] concreteDomains, Domain[] abstractDomains) {
        this.abstractionManager = manager;
        this.concreteDomains = concreteDomains;
        this.abstractDomains = abstractDomains;
    }

    protected ApproximationRelation(AbstractionManager manager, Domain concreteDomain, Domain abstractDomain) {
        this(manager, new Domain[]{concreteDomain}, new Domain[]{abstractDomain});
    }

    protected ApproximationRelation(AbstractionManager manager, Domain concreteDomain, Domain[] abstractDomains) {
        this(manager, new Domain[]{concreteDomain}, abstractDomains);
    }

    protected ApproximationRelation(AbstractionManager manager, Domain[] concreteDomains, Domain abstractDomain) {
        this(manager, concreteDomains, new Domain[]{abstractDomain});
    }

    protected boolean canApplyConcretizationTo(Domain concreteDomain) {
        return true;
    }

    protected void concretize(Concretizator concretizator) {
        throw new MissingImplementationException();
    }

    private void updateConcreteDomains() {
        int i = 0;
        while (i < this.concreteDomains.length) {
            if (this.canApplyConcretizationTo(this.concreteDomains[i])) {
                Concretizator concretizator = this.abstractionManager.getConcretizator(this.concreteDomains[i].getId());
                if (!concretizator.isStartedConcretization()) {
                    concretizator.setElementsTo(false);
                    this.concretize(concretizator);
                    assert (concretizator.controlNotEmptyDomain());
                    concretizator.setStartedConcretization(true);
                } else {
                    concretizator.save();
                    concretizator.setElementsTo(false);
                    this.concretize(concretizator);
                    assert (concretizator.controlNotEmptyDomain());
                    concretizator.doLogicalAndWithSaving();
                }
            }
            ++i;
        }
    }

    protected void updateGuidingConstraint() {
        throw new MissingImplementationException();
    }

    void updateConcreteProblem() {
        this.updateConcreteDomains();
        if (this.guidingConstraint != null) {
            this.updateGuidingConstraint();
        }
    }

    public void display() {
        System.out.println();
        System.out.println("Approximation relation with index = " + this.id);
        System.out.print("  linking " + this.concreteDomains.length + " concrete domains with ");
        System.out.println(this.abstractDomains.length + " abstract domains");
        int i = 0;
        while (i < this.concreteDomains.length) {
            this.concreteDomains[i].display();
            ++i;
        }
        i = 0;
        while (i < this.abstractDomains.length) {
            this.abstractDomains[i].display();
            ++i;
        }
    }
}

