/*
 * Decompiled with CFR 0.152.
 */
package abscon.abstraction;

import abscon.Resolution;
import abscon.abstraction.ApproximationRelation;
import abscon.abstraction.Concretizator;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.solvers.Solver;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AbstractionManager {
    private Resolution resolution;
    private int levelInResolution;
    private ApproximationRelation[] approximationsRelations;
    private Concretizator[] concretizators;
    private Collection<ApproximationRelation> collectedRelations = new LinkedList<ApproximationRelation>();

    public Resolution getResolution() {
        return this.resolution;
    }

    public int getLevelInResolution() {
        return this.levelInResolution;
    }

    public ApproximationRelation[] getApproximationRelations() {
        return this.approximationsRelations;
    }

    protected Problem getConcreteProblem() {
        return this.resolution.getProblem(this.levelInResolution);
    }

    protected Problem getAbstractProblem() {
        return this.resolution.getProblem(this.levelInResolution + 1);
    }

    public Solver getConcreteSolver() {
        return this.resolution.getSolver(this.levelInResolution);
    }

    protected Solver getAbstractSolver() {
        return this.resolution.getSolver(this.levelInResolution + 1);
    }

    protected Concretizator getConcretizator(int i) {
        return this.concretizators[i];
    }

    protected abstract void addApproximationRelations();

    public final void addApproximationRelation(ApproximationRelation relation) {
        relation.setId(this.collectedRelations.size());
        this.collectedRelations.add(relation);
    }

    public void attachTo(Resolution resolution, int levelInResolution) {
        this.resolution = resolution;
        this.levelInResolution = levelInResolution;
        Variable[] concreteVariables = this.getConcreteProblem().getVariables();
        this.concretizators = new Concretizator[concreteVariables.length];
        int i = 0;
        while (i < this.concretizators.length) {
            this.concretizators[i] = new Concretizator(this, concreteVariables[i].getDomain());
            ++i;
        }
        this.addApproximationRelations();
        this.approximationsRelations = this.collectedRelations.toArray(new ApproximationRelation[0]);
    }

    public void runConcreteSolver() {
        int i = 0;
        while (i < this.concretizators.length) {
            this.concretizators[i].setStartedConcretization(false);
            ++i;
        }
        i = 0;
        while (i < this.approximationsRelations.length) {
            this.approximationsRelations[i].updateConcreteProblem();
            ++i;
        }
        boolean emptyDomain = false;
        int i2 = 0;
        while (!emptyDomain && i2 < this.concretizators.length) {
            if (!this.concretizators[i2].isStartedConcretization()) {
                this.concretizators[i2].setElementsTo(true);
            }
            emptyDomain = this.concretizators[i2].finishInitialization() == 0;
            ++i2;
        }
        if (!emptyDomain) {
            this.getConcreteSolver().solve();
        }
    }

    public void display() {
        int i = 0;
        while (i < this.approximationsRelations.length) {
            this.approximationsRelations[i].display();
            ++i;
        }
    }
}

