/*
 * Decompiled with CFR 0.152.
 */
package abscon;

import abscon.ExtractionResolution;
import abscon.abstraction.AbstractionManager;
import abscon.constraints.extension.ExtensionConstraint;
import abscon.constraints.extension.structures.Bits;
import abscon.constraints.universal.UniversalConstraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.heuristics.valueOrdering.statc.RawLexico;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.forwardPropagationTechniques.maxCSP.MaxCSP;
import abscon.propagationTechniques.forwardPropagationTechniques.maxCSP.SingletonMaxCSP3Single;
import abscon.propagationTechniques.revisionManagers.RevisionManager0;
import abscon.propagationTechniques.supportManagers.SupportManager3;
import abscon.solvers.GraphManager;
import abscon.solvers.Solver;
import abscon.solvers.localSolvers.LocalSearchSolver;
import abscon.solvers.systematicSolvers.ExtractionSolver;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.Stopwatch;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ArgumentsManager;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.absconParameters.StatisticsManager;
import abscon.tools.reflection.Factory;
import abscon.xml.OutputManager;
import abscon.xml.STDOutput;
import java.util.LinkedHashMap;
import java.util.Random;

public class Resolution {
    protected Problem[] problems;
    protected Solver[] solvers;
    protected AbstractionManager[] managers;
    protected int nbSearchedSolutions;
    protected long timeLimit;
    protected boolean recordSolutions;
    protected boolean successful;
    protected int displayMode;
    protected boolean conciseResults;
    private boolean competition;
    private double versionXCSP;
    protected STDOutput stdOutput;
    protected static OutputManager outputManager;
    protected StatisticsManager statisticsManager;
    private Stopwatch buildingPhaseStopwatch = new Stopwatch();
    private Stopwatch currentInstanceStopwatch = new Stopwatch();
    protected Random random = new Random();
    private boolean spaceReductionMode;
    private boolean backPruning = false;
    private static int nb;
    private boolean testConnex = false;
    private Problem auxiliaryProblem;
    private SystematicSolver auxiliarySolver;
    private int[] variableIds;
    private int[] indexes;
    private static final int PSEUDO = 0;
    private static final int CSP = 1;
    private int competitionMode = 1;
    private boolean passed;
    private static Stopwatch resolutionStopwatch;
    static boolean retry;

    static {
        nb = 0;
    }

    public String getName() {
        return this.getNbAbstractionLevels() == 0 ? "classical resolution" : "hybrid resolution with " + this.getNbAbstractionLevels() + " level(s)";
    }

    public int getNbAbstractionLevels() {
        return this.managers.length;
    }

    public Problem getProblem(int i) {
        return this.problems[i];
    }

    public Solver getSolver(int i) {
        return this.solvers[i];
    }

    public AbstractionManager getManager(int i) {
        return this.managers[i];
    }

    public Solver getTopSolver() {
        return this.solvers[this.solvers.length - 1];
    }

    public int getNbSearchedSolutions() {
        return this.nbSearchedSolutions;
    }

    public boolean isCompetition() {
        return this.competition;
    }

    public Stopwatch getCurrentInstanceStopwatch() {
        return this.currentInstanceStopwatch;
    }

    public Stopwatch getBuildingStopwatch() {
        return this.buildingPhaseStopwatch;
    }

    public Random getRandom() {
        return this.random;
    }

    public boolean getRecordSolutions() {
        return this.recordSolutions;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public boolean getConciseResults() {
        return this.conciseResults;
    }

    public boolean isTimeExpired() {
        return this.timeLimit > 0L && this.timeLimit <= this.currentInstanceStopwatch.getCurrentCpuTime();
    }

    public void setSuccessful(boolean b) {
        this.successful = b;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean isFinished() {
        return this.isSuccessful() || this.isTimeExpired();
    }

    public OutputManager getOutputManager() {
        return outputManager;
    }

    public double getVersionXCSP() {
        return this.versionXCSP;
    }

    public boolean isSpaceReductionMode() {
        return this.spaceReductionMode;
    }

    public Resolution(boolean spaceReductionMode) {
        String className;
        this.spaceReductionMode = spaceReductionMode;
        int nbAbstractionLevels = ConfigurationManager.getInt("//nbAbstractionLevels", "value");
        this.problems = new Problem[nbAbstractionLevels + 1];
        this.solvers = new Solver[nbAbstractionLevels + 1];
        this.managers = new AbstractionManager[nbAbstractionLevels];
        this.nbSearchedSolutions = ConfigurationManager.getInt("//nbSearchedSolutions", "value");
        this.timeLimit = ConfigurationManager.getInt("//timeout", "value") * 1000;
        this.recordSolutions = ConfigurationManager.getBoolean("//recordSolutions", "value");
        this.displayMode = ConfigurationManager.getInt("//displayMode", "value");
        this.conciseResults = ConfigurationManager.getBoolean("//conciseResults", "value");
        this.competition = ConfigurationManager.getBoolean("//competition", "value");
        this.versionXCSP = ConfigurationManager.getDouble("//XCSP", "version");
        if (ArgumentsManager.getNbInstances() > 1) {
            this.statisticsManager = new StatisticsManager(this);
        }
        if ((className = ConfigurationManager.getString(0, "preprocessing/propagationTechnique", "class")).equals(Tools.getRelativeClassNameOf(MaxCSP.class)) || className.equals(Tools.getRelativeClassNameOf(SingletonMaxCSP3Single.class))) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (!Resolution.this.passed && !Resolution.this.solvers[0].isInProgress() && Resolution.this.solvers[0].getLastSolution() != null) {
                        System.out.println("v " + Resolution.this.solvers[0].getLastSolution().toString());
                    }
                }
            });
        }
    }

    protected Problem buildProblemInstance(int level, int instanceNumber) {
        Stopwatch stopwatch = new Stopwatch();
        String className = String.valueOf(ArgumentsManager.getPackageName()) + ".Problem" + level;
        Problem problem = (Problem)Factory.getInstanceOf(className);
        problem.attachTo(this, level, instanceNumber);
        problem.setDurationToBeBuilt(stopwatch.getCurrentWallClockTime());
        return problem;
    }

    protected Solver buildSolverInstance(int level) {
        Stopwatch stopwatch = new Stopwatch();
        String solverClassName = ConfigurationManager.getString(level, "solver", "class");
        System.out.println(OutputManager.COMMENT_PREFIX);
        System.out.println(String.valueOf(OutputManager.COMMENT_PREFIX) + "solver " + solverClassName + " being built... ");
        Solver solver = (Solver)Factory.getInstanceOf(solverClassName, Solver.class);
        solver.attachTo(this, level);
        solver.setDurationToBeBuilt(stopwatch.getCurrentWallClockTime());
        if (solver instanceof ExtractionSolver && !(this instanceof ExtractionResolution)) {
            throw new IncompatiblePropertiesException();
        }
        outputManager.outputMap("solver", solver.getMapOfAttributes(), 1);
        return solver;
    }

    protected AbstractionManager buildManagerInstance(int level) {
        String s = String.valueOf(ArgumentsManager.getPackageName()) + ".Manager" + level;
        AbstractionManager manager = (AbstractionManager)Factory.getInstanceOf(s);
        manager.attachTo(this, level);
        return manager;
    }

    protected void updateGlobalStatistics() {
        if (this.statisticsManager != null) {
            this.statisticsManager.update();
        }
    }

    protected void displayGlobalStatistics() {
        if (this.statisticsManager != null) {
            this.statisticsManager.outputGlobalStatistics();
        }
    }

    public SystematicSolver getAuxiliarySolver() {
        return this.auxiliarySolver;
    }

    public int test(Variable var, int index) {
        if (!this.backPruning) {
            return -1;
        }
        SystematicSolver solver = (SystematicSolver)this.solvers[0];
        VariableManager manager = solver.getVariableManager();
        int nbPast = solver.getNbPastVariables();
        Variable variable = manager.getLastPastVariable();
        while (variable != null) {
            this.variableIds[nbPast] = variable.getId();
            this.indexes[nbPast] = variable.getDomain().getUniqueIndex();
            --nbPast;
            variable = manager.getPrevPastVariableBefore(variable);
        }
        this.variableIds[0] = var.getId();
        this.indexes[0] = index;
        int level = this.auxiliarySolver.doGreedy(this.variableIds, this.indexes, solver.getNbPastVariables());
        System.out.println(var + " " + index + " std level = " + solver.getNbPastVariables() + " cpt level = " + level);
        return level;
    }

    public void buildAuxiliaryProblemAndSolver() {
        int num = this.problems[0].getInstanceNumber();
        Problem tmp = this.problems[0];
        this.problems[0] = this.buildProblemInstance(0, num);
        this.auxiliarySolver = (SystematicSolver)this.buildSolverInstance(0);
        this.auxiliaryProblem = this.problems[0];
        this.auxiliaryProblem.setSolver(this.auxiliarySolver);
        this.problems[0] = tmp;
        this.auxiliaryProblem.fixDomains();
        PropagationTechnique pt = this.auxiliarySolver.getSearchPropagationTechnique();
        pt.initializeBeforeRun();
        this.variableIds = new int[this.auxiliarySolver.getNbVariables()];
        this.indexes = new int[this.auxiliarySolver.getNbVariables()];
    }

    protected void solveInstance(int num) {
        outputManager.outputMap("resolution", new LinkedHashMap<String, String>(), 0);
        this.currentInstanceStopwatch.start();
        this.buildingPhaseStopwatch.start();
        this.random.setSeed(num);
        int i = 0;
        while (i < this.problems.length) {
            this.problems[i] = this.buildProblemInstance(i, num);
            ++i;
        }
        i = 0;
        while (i < this.managers.length) {
            this.managers[i] = this.buildManagerInstance(i);
            ++i;
        }
        if (this.managers.length > 0) {
            i = 0;
            while (i < this.problems.length) {
                this.problems[i].storeConstraintsToArray();
                ++i;
            }
        }
        boolean preproLocalSearch = ConfigurationManager.getBoolean(0, "solver", "localPrepro");
        StringBuffer sb = null;
        if (preproLocalSearch) {
            String solverClassName = ConfigurationManager.getString(0, "solver", "class");
            ConfigurationManager.setString(0, "solver", "class", Tools.getRelativeClassNameOf(LocalSearchSolver.class));
            String cutoff = ConfigurationManager.getString(0, "search/restarts", "cutoff");
            ConfigurationManager.setString(0, "search/restarts", "cutoff", "10000");
            String prepro = ConfigurationManager.getString(0, "preprocessing", "enabled");
            ConfigurationManager.setString(0, "preprocessing", "enabled", "no");
            this.solvers[0] = this.buildSolverInstance(0);
            this.problems[0].setSolver(this.solvers[0]);
            this.problems[0].fixDomains();
            this.setSuccessful(false);
            this.getTopSolver().solve();
            Variable[] variableArray = this.problems[0].getVariables();
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable variable = variableArray[n];
                variable.getDomain().setUniqueIndex(-10);
                ++n;
            }
            sb = this.getTopSolver().getLastSolution();
            ConfigurationManager.setString(0, "preprocessing/propagationTechnique", "upperBound", String.valueOf(((LocalSearchSolver)this.getTopSolver()).getUpperBound()));
            ConfigurationManager.setString(0, "solver", "class", solverClassName);
            ConfigurationManager.setString(0, "search/restarts", "cutoff", cutoff);
            ConfigurationManager.setString(0, "preprocessing", "enabled", prepro);
            if (this.isSuccessful()) {
                return;
            }
        }
        int i2 = 0;
        while (i2 < this.solvers.length) {
            this.solvers[i2] = this.buildSolverInstance(i2);
            ++i2;
        }
        String className = ConfigurationManager.getString(0, "preprocessing/propagationTechnique", "class");
        if (className.equals(Tools.getRelativeClassNameOf(MaxCSP.class)) || className.equals(Tools.getRelativeClassNameOf(SingletonMaxCSP3Single.class))) {
            this.solvers[0].setLastSolution(sb);
        }
        int i3 = 0;
        while (i3 < this.problems.length) {
            this.problems[i3].setSolver(this.solvers[i3]);
            if (!preproLocalSearch) {
                this.problems[i3].fixDomains();
            }
            ++i3;
        }
        this.setSuccessful(false);
        this.display();
        this.buildingPhaseStopwatch.stop();
        this.getTopSolver().solve();
        this.currentInstanceStopwatch.stop();
        if (!this.competition) {
            this.getTopSolver().getProblem().saveXMLDescription();
        }
        this.updateGlobalStatistics();
        if (this.testConnex) {
            GraphManager gm = new GraphManager((SystematicSolver)this.getTopSolver());
            gm.determineConnexComponents();
            if (gm.getNbComponents() > 1) {
                System.out.println("Nb disconnected graphs = " + nb++);
            }
        }
    }

    public boolean isPseudoCompetition() {
        return this.competition && this.competitionMode == 0;
    }

    private void dealWithCompetition(double wallClockTime) {
        this.passed = true;
        if (this.solvers[0].getPreproPropagationTechnique() instanceof MaxCSP) {
            System.out.println();
            System.out.println("s OPTIMUM FOUND");
            System.out.println("v " + this.solvers[0].getLastSolution().toString());
        } else {
            System.out.println(OutputManager.COMMENT_PREFIX);
            if (this.solvers[0].getStatistics().getNbFoundSolutions() > 0L) {
                System.out.println("s SATISFIABLE");
                System.out.println("v " + this.solvers[0].getLastSolution().toString());
            } else if (this.solvers[0].getFullExploration()) {
                System.out.println("s UNSATISFIABLE");
            } else {
                System.out.println("s UNKNOWN");
            }
            System.out.println("d NODES " + this.solvers[0].getStatistics().getNbAssignments());
            System.out.println("d CHECKS " + this.solvers[0].getStatistics().getNbConstraintChecks());
        }
        System.out.flush();
    }

    public void solveInstances(long elapsedTime) {
        this.timeLimit -= elapsedTime;
        outputManager = new OutputManager(!this.competition);
        int i = 0;
        while (i < ArgumentsManager.getNbInstances()) {
            this.solveInstance(i);
            ++i;
        }
        this.dealWithCompetition(resolutionStopwatch.getCurrentWallClockTime());
        this.displayGlobalStatistics();
        outputManager.save(resolutionStopwatch.getCurrentWallClockTime());
        System.out.println(OutputManager.COMMENT_PREFIX);
        System.out.println(String.valueOf(OutputManager.COMMENT_PREFIX) + "totalWckTime=" + (double)resolutionStopwatch.getCurrentWallClockTime() / 1000.0 + OutputManager.DATA_SEPARATOR + "totalCpuTime=" + (double)resolutionStopwatch.getCurrentCpuTime() / 1000.0);
    }

    public void display() {
        if (this.displayMode <= 0) {
            return;
        }
        int i = 0;
        while (i < this.problems.length) {
            if (this.displayMode == 1) {
                this.problems[i].display();
            }
            if (this.displayMode == 2) {
                this.problems[i].displayExhaustively();
            }
            ++i;
        }
        i = 0;
        while (i < this.managers.length) {
            this.managers[i].display();
            ++i;
        }
    }

    public static Stopwatch getResolutionStopwatch() {
        return resolutionStopwatch;
    }

    public static void loadArgumentsAndConfiguration(String[] args) {
        ArgumentsManager.setArguments(args);
        ConfigurationManager.loadConfigurationFile(ArgumentsManager.getConfigurationFileName());
        retry = ConfigurationManager.getBoolean("//retry", "value");
        if (retry && ArgumentsManager.getNbInstances() > 1) {
            throw new IncompatiblePropertiesException();
        }
        resolutionStopwatch = new Stopwatch();
    }

    private static boolean canTryResolutionTentative(int nb) {
        if (nb == 0) {
            return true;
        }
        if (retry && nb == 1) {
            String prefix = "/propagationTechnique";
            String tag = "preprocessing" + prefix + "/" + "supportManager";
            ConfigurationManager.setString(0, tag, "class", Tools.getRelativeClassNameOf(SupportManager3.class));
            tag = "preprocessing" + prefix + "/" + "revisionManager";
            ConfigurationManager.setString(0, tag, "class", Tools.getRelativeClassNameOf(RevisionManager0.class));
            tag = "search/valueHeuristic";
            ConfigurationManager.setString(0, tag, "class", Tools.getRelativeClassNameOf(RawLexico.class));
            ConfigurationManager.setString(0, tag, "optim", "min");
            tag = "problem/convertBinaryConstraintsInExtension";
            ConfigurationManager.setString(0, tag, "value", "no");
            tag = "search/solutionCounter";
            ConfigurationManager.setString(0, tag, "mode", "0");
            tag = "problem/extension";
            ConfigurationManager.setString(0, tag, "type", "0");
            return true;
        }
        System.out.println("s UNKNOWN");
        System.out.flush();
        return false;
    }

    public static void main(String[] args) {
        Resolution.loadArgumentsAndConfiguration(args);
        int nbTentatives = 0;
        while (Resolution.canTryResolutionTentative(nbTentatives)) {
            Resolution resolution = null;
            try {
                resolution = new Resolution(false);
                resolution.solveInstances(resolutionStopwatch.getCurrentCpuTime() / 1000L);
                break;
            }
            catch (Throwable t) {
                Bits.clearMap();
                ExtensionConstraint.clear();
                UniversalConstraint.clear();
                if (resolution != null && resolution.getSolver(0) != null && resolution.getSolver(0) instanceof SystematicSolver && ((SystematicSolver)resolution.getSolver(0)).getSolutionCounter() != null) {
                    ((SystematicSolver)resolution.getSolver(0)).getSolutionCounter().clear();
                }
                resolution = null;
                System.gc();
                t.printStackTrace();
                outputManager.outputError(t.toString());
                ++nbTentatives;
            }
        }
    }
}

