/*
 * Decompiled with CFR 0.152.
 */
package abscon;

import XSax.Problem0;
import abscon.Resolution;
import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.solvers.systematicSolvers.ExtractionSolver;
import abscon.tools.Stopwatch;
import abscon.tools.absconParameters.ArgumentsManager;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.reflection.Factory;
import abscon.xml.Cores;
import abscon.xml.OutputManager;
import abscon.xml.ProblemDocumentBuilder;
import abscon.xml.State;
import abscon.xml.XMLManipulation;
import abscon.xml.XMLProblemModifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Document;

public class ExtractionResolution
extends Resolution {
    private int passNumber;
    private int extractionNumber;
    private Approach approach;
    private int nbSearchedCores;
    private LinkedList<String> coreOfVariables;
    private LinkedList<String> coreOfConstraints;
    private KernelStatistics kernelStatistics = new KernelStatistics();
    private boolean useWeightingToOrderConstraints = true;
    private boolean onlyFirst = false;
    private int wcoreMode = 0;

    public int getCurrentPassNumber() {
        return this.passNumber;
    }

    public int getCurrentExtractionNumber() {
        return this.extractionNumber;
    }

    private String getExtractionFileNameFor(int i, int j) {
        return "extraction_" + i + "_" + j + ".xml";
    }

    public String getPreviousExtractionFileName() {
        return this.getExtractionFileNameFor(this.passNumber, this.extractionNumber - 1);
    }

    public String getCurrentExtractionFileName() {
        return this.getExtractionFileNameFor(this.passNumber, this.extractionNumber);
    }

    public ExtractionResolution() {
        super(false);
        if (this.problems.length > 1) {
            throw new IncompatiblePropertiesException();
        }
        boolean saveXMLDescription = ConfigurationManager.getBoolean("//saveProblemDescription", "value");
        if (!saveXMLDescription) {
            throw new IncompatiblePropertiesException();
        }
        this.nbSearchedCores = ConfigurationManager.getInt(0, "solver", "nbCores");
        if (this.nbSearchedCores == -1) {
            this.nbSearchedCores = Integer.MAX_VALUE;
        }
        this.approach = Approach.getApproachFor(ConfigurationManager.getInt(0, "solver", "mode"));
        if (this.approach == Approach.INC_FIRST) {
            this.onlyFirst = true;
        }
    }

    protected Problem buildProblemInstance(int level, int instanceNumber) {
        Problem problem = null;
        if (this.passNumber == 0 && this.extractionNumber == 0) {
            problem = super.buildProblemInstance(level, instanceNumber);
            Constraint[] constraintArray = problem.getConstraints();
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                constraint.setName(constraint.getDefaultName());
                ++n;
            }
            Document document = ProblemDocumentBuilder.buildDocumentOf(problem, true, false);
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
        } else {
            Problem0.clearInstanceFileNames();
            ArgumentsManager.setParameter("First", "y");
            ArgumentsManager.setParameter("Name ", this.getCurrentExtractionFileName());
            Stopwatch stopwatch = new Stopwatch();
            problem = (Problem)Factory.getInstanceOf("XSax.Problem0");
            problem.attachTo(this, level, instanceNumber);
            problem.setDurationToBeBuilt(stopwatch.getCurrentWallClockTime());
        }
        return problem;
    }

    private boolean solveCurrentNetwork(int num, boolean simple) {
        this.problems[0] = this.buildProblemInstance(0, num);
        this.solvers[0] = this.buildSolverInstance(0);
        this.problems[0].fixDomains();
        this.problems[0].setSolver(this.solvers[0]);
        this.setSuccessful(false);
        return ((ExtractionSolver)this.solvers[0]).solve(simple);
    }

    private boolean manageFixPoint(int num, boolean variableFixpoint) {
        System.out.println(String.valueOf(variableFixpoint ? "Variable" : "Constraint") + " fixpoint = " + this.getCurrentExtractionFileName());
        String fixPointFileName = this.getCurrentExtractionFileName();
        Document document = XMLManipulation.load(fixPointFileName);
        int cursor = 0;
        while (cursor < XMLProblemModifier.getNbVariablesOrConstraints(document, variableFixpoint)) {
            ++this.extractionNumber;
            XMLProblemModifier.deleteVariableOrConstraint(document, cursor, variableFixpoint);
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
            boolean satisfiable = this.solveCurrentNetwork(num, true);
            if (satisfiable) {
                ++cursor;
                document = XMLManipulation.load(fixPointFileName);
                continue;
            }
            boolean toBeSaved = false;
            Variable[] variableArray = this.solvers[0].getVariables();
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable variable = variableArray[n];
                if (variable.getDegree() == 0) {
                    XMLProblemModifier.deleteVariable(document, variable.getName());
                    toBeSaved = true;
                }
                ++n;
            }
            if (toBeSaved) {
                XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
            }
            fixPointFileName = this.getCurrentExtractionFileName();
        }
        if (this.solvers[0].getStatistics().getNbFoundSolutions() != 0L) {
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
        }
        if (variableFixpoint) {
            return this.manageFixPoint(num, false);
        }
        return true;
    }

    private Document findVariablesOfCore(int num, boolean onlyOneVariable) {
        OutputManager.printInfo("Finding Variable approach starts");
        Problem problem = this.problems[0];
        Variable[] variables = (Variable[])problem.getVariables().clone();
        boolean[] presentVariables = new boolean[variables.length];
        Arrays.sort(variables, new VariableComparator());
        int frontier = variables.length - 1;
        Variable lastVariableFoundInCore = null;
        Document document = null;
        boolean finished = false;
        while (!(finished || onlyOneVariable && lastVariableFoundInCore != null)) {
            String before = this.getCurrentExtractionFileName();
            if (lastVariableFoundInCore != null) {
                int i = frontier - 1;
                while (i >= this.coreOfVariables.size() - 1) {
                    variables[i + 1] = variables[i];
                    --i;
                }
                variables[this.coreOfVariables.size() - 1] = lastVariableFoundInCore;
            }
            int min = this.coreOfVariables.size();
            int i = 0;
            while (i < min) {
                presentVariables[variables[i].getId()] = true;
                ++i;
            }
            int max = frontier;
            String fileNameOfLastUnsatExtraction = null;
            while (min != max) {
                int center = min + (max - min) / 2;
                int i2 = min;
                while (i2 <= center) {
                    presentVariables[variables[i2].getId()] = true;
                    ++i2;
                }
                i2 = center + 1;
                while (i2 <= max) {
                    presentVariables[variables[i2].getId()] = false;
                    ++i2;
                }
                System.out.println("min = " + min + " max = " + max + " center = " + center);
                ++this.extractionNumber;
                XMLManipulation.saveInstance(ProblemDocumentBuilder.buildDocumentOf(new State(problem, presentVariables), true, false), this.getCurrentExtractionFileName());
                if (!this.solveCurrentNetwork(num, true)) {
                    fileNameOfLastUnsatExtraction = this.getCurrentExtractionFileName();
                    max = center;
                    continue;
                }
                min = center + 1;
            }
            lastVariableFoundInCore = variables[max];
            this.coreOfVariables.add(lastVariableFoundInCore.getName());
            System.out.println("variable " + lastVariableFoundInCore.getName() + " core size " + (this.coreOfVariables.size() + 1));
            document = XMLManipulation.load(fileNameOfLastUnsatExtraction == null ? before : fileNameOfLastUnsatExtraction);
            ++this.extractionNumber;
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
            frontier = XMLProblemModifier.getNbVariablesIn(document) - 1;
            if (this.coreOfVariables.size() != frontier + 1) continue;
            finished = true;
            XMLProblemModifier.deleteVariable(document, this.coreOfVariables.getLast());
            ++this.extractionNumber;
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
            if (!this.solveCurrentNetwork(num, true)) continue;
            document = XMLManipulation.load(this.getPreviousExtractionFileName());
            ++this.extractionNumber;
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
        }
        return document;
    }

    private Document findConstraintsOfCore(int num, boolean onlyOneConstraint) {
        Problem problem = this.problems[0];
        Constraint[] constraints = (Constraint[])problem.getConstraints().clone();
        boolean[] presentConstraints = new boolean[constraints.length];
        if (this.useWeightingToOrderConstraints) {
            if (this.solvers[0].getStatistics().getNbPreproInconsistencies() == 0) {
                Arrays.sort(constraints, new ConstraintComparator());
            } else {
                Arrays.sort(constraints, new ConstraintComparator2());
            }
        }
        int frontier = constraints.length - 1;
        Constraint lastConstraintFoundInCore = null;
        Document document = null;
        boolean finished = false;
        while (!(finished || onlyOneConstraint && lastConstraintFoundInCore != null)) {
            String before = this.getCurrentExtractionFileName();
            if (lastConstraintFoundInCore != null) {
                assert (lastConstraintFoundInCore == constraints[frontier]);
                int i = frontier - 1;
                while (i >= this.coreOfConstraints.size() - 1) {
                    constraints[i + 1] = constraints[i];
                    --i;
                }
                constraints[this.coreOfConstraints.size() - 1] = lastConstraintFoundInCore;
            }
            int min = this.coreOfConstraints.size();
            int i = 0;
            while (i < min) {
                presentConstraints[constraints[i].getId()] = true;
                ++i;
            }
            int max = frontier;
            String fileNameOfLastUnsatExtraction = null;
            while (min != max) {
                int center = min + (max - min) / 2;
                System.out.println("min = " + min + " max = " + max + " center = " + center);
                int i2 = min;
                while (i2 <= center) {
                    presentConstraints[constraints[i2].getId()] = true;
                    ++i2;
                }
                i2 = center + 1;
                while (i2 <= max) {
                    presentConstraints[constraints[i2].getId()] = false;
                    ++i2;
                }
                ++this.extractionNumber;
                XMLManipulation.saveInstance(ProblemDocumentBuilder.buildDocumentOf(new State(problem, presentConstraints, false), true, false), this.getCurrentExtractionFileName());
                if (!this.solveCurrentNetwork(num, true)) {
                    fileNameOfLastUnsatExtraction = this.getCurrentExtractionFileName();
                    max = center;
                    continue;
                }
                min = center + 1;
            }
            lastConstraintFoundInCore = constraints[max];
            this.coreOfConstraints.add(lastConstraintFoundInCore.getName());
            System.out.println("constraint " + lastConstraintFoundInCore.getName() + " core size " + (this.coreOfConstraints.size() + 1));
            document = XMLManipulation.load(fileNameOfLastUnsatExtraction == null ? before : fileNameOfLastUnsatExtraction);
            ++this.extractionNumber;
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
            frontier = XMLProblemModifier.getNbConstraintsIn(document) - 1;
            if (this.coreOfConstraints.size() != frontier + 1) continue;
            finished = true;
            XMLProblemModifier.deleteConstraint(document, this.coreOfConstraints.getLast());
            ++this.extractionNumber;
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
            if (!this.solveCurrentNetwork(num, true)) continue;
            document = XMLManipulation.load(this.getPreviousExtractionFileName());
            ++this.extractionNumber;
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
        }
        return document;
    }

    private boolean findDecreasinglyDiagnosisElement(int num) {
        Problem problem = this.problems[0];
        Constraint[] constraints = (Constraint[])problem.getConstraints().clone();
        boolean[] presentConstraints = new boolean[constraints.length];
        Arrays.fill(presentConstraints, true);
        if (this.solvers[0].getStatistics().getNbPreproInconsistencies() == 0) {
            Arrays.sort(constraints, new ConstraintComparator());
        } else {
            Arrays.sort(constraints, new ConstraintComparator2());
        }
        int i = 0;
        while (i < presentConstraints.length) {
            presentConstraints[constraints[i].getId()] = false;
            ++this.extractionNumber;
            Document document = ProblemDocumentBuilder.buildDocumentOf(new State(problem, presentConstraints, false), true, false);
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
            if (this.solveCurrentNetwork(num, true)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean findDecreasinglyDiagnosisElementAll(int num) {
        Problem problem = this.problems[0];
        Constraint[] constraints = problem.getConstraints();
        if (this.solvers[0].getStatistics().getNbPreproInconsistencies() == 0) {
            Arrays.sort(constraints, new ConstraintComparator());
        } else {
            Arrays.sort(constraints, new ConstraintComparator2());
        }
        ++this.extractionNumber;
        Document document = ProblemDocumentBuilder.buildDocumentOf(problem, true, false);
        XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
        return this.manageFixPoint(num, false);
    }

    private boolean findIncreasinglyDiagnosisElement(int num) {
        Problem problem = this.problems[0];
        Constraint[] constraints = (Constraint[])problem.getConstraints().clone();
        boolean[] presentConstraints = new boolean[constraints.length];
        if (this.solvers[0].getStatistics().getNbPreproInconsistencies() == 0) {
            Arrays.sort(constraints, new ConstraintComparator());
        } else {
            Arrays.sort(constraints, new ConstraintComparator2());
        }
        int limit = presentConstraints.length - 1;
        while (this.coreOfConstraints.size() < limit) {
            int fr = this.coreOfConstraints.size();
            while (fr < presentConstraints.length) {
                presentConstraints[constraints[fr].getId()] = true;
                ++this.extractionNumber;
                Document document = ProblemDocumentBuilder.buildDocumentOf(new State(problem, presentConstraints, false), true, false);
                XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
                if (!this.solveCurrentNetwork(num, true)) break;
                ++fr;
            }
            Constraint lastConstraintFoundInCore = constraints[fr];
            this.coreOfConstraints.add(lastConstraintFoundInCore.getName());
            System.out.println("constraint " + lastConstraintFoundInCore.getName() + " core size " + this.coreOfConstraints.size() + " fr = " + fr);
            if (this.onlyFirst) {
                return true;
            }
            int i = fr - 1;
            while (i >= this.coreOfConstraints.size() - 1) {
                constraints[i + 1] = constraints[i];
                --i;
            }
            constraints[this.coreOfConstraints.size() - 1] = lastConstraintFoundInCore;
            i = this.coreOfConstraints.size();
            while (i <= fr) {
                presentConstraints[constraints[i].getId()] = false;
                ++i;
            }
            limit = fr;
        }
        presentConstraints[constraints[limit].getId()] = false;
        ++this.extractionNumber;
        Document document = ProblemDocumentBuilder.buildDocumentOf(new State(problem, presentConstraints, false), true, false);
        XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
        if (this.solveCurrentNetwork(num, true)) {
            document = XMLManipulation.load(this.getPreviousExtractionFileName());
            ++this.extractionNumber;
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
        }
        return true;
    }

    private Document manageMaxCSP(int num, boolean onlyOneConstraint) {
        Problem problem = this.problems[0];
        Constraint[] constraints = (Constraint[])problem.getConstraints().clone();
        boolean[] presentConstraints = new boolean[constraints.length];
        if (this.useWeightingToOrderConstraints) {
            if (this.solvers[0].getStatistics().getNbPreproInconsistencies() == 0) {
                Arrays.sort(constraints, new ConstraintComparator());
            } else {
                Arrays.sort(constraints, new ConstraintComparator2());
            }
        }
        Document document = null;
        int min = 0;
        int max = constraints.length - 1;
        while (min != max) {
            int center = min + (max - min) / 2;
            System.out.println("min = " + min + " max = " + max + " center = " + center);
            int i = min;
            while (i <= center) {
                presentConstraints[constraints[i].getId()] = true;
                ++i;
            }
            i = center + 1;
            while (i <= max) {
                presentConstraints[constraints[i].getId()] = false;
                ++i;
            }
            ++this.extractionNumber;
            XMLManipulation.saveInstance(ProblemDocumentBuilder.buildDocumentOf(new State(problem, presentConstraints, false), true, false), this.getCurrentExtractionFileName());
            if (!this.solveCurrentNetwork(num, true)) {
                max = center;
                continue;
            }
            min = center + 1;
        }
        Constraint transitionConstraint = constraints[max];
        System.out.println("found : " + transitionConstraint);
        Arrays.fill(presentConstraints, false);
        presentConstraints[transitionConstraint.getId()] = true;
        document = ProblemDocumentBuilder.buildDocumentOf(new State(problem, presentConstraints, false), true, false);
        ++this.extractionNumber;
        XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
        return document;
    }

    private boolean extractNextCore(int num) {
        boolean satisfiable = this.solveCurrentNetwork(num, this.wcoreMode > 0);
        if (this.extractionNumber == 0 && satisfiable) {
            return false;
        }
        this.coreOfVariables = new LinkedList();
        this.coreOfConstraints = new LinkedList();
        boolean proofFixpoint = this.wcoreMode == 2;
        while (!proofFixpoint) {
            int nbActiveConstraints = ((ExtractionSolver)this.solvers[0]).getNbActiveConstraints();
            if (nbActiveConstraints == this.problems[0].getNbConstraints()) {
                proofFixpoint = true;
                continue;
            }
            ++this.extractionNumber;
            if (this.wcoreMode == 1) {
                ((ExtractionSolver)this.solvers[0]).setActiveConstraintsFromEffectiveRevisors();
            }
            Document document = ProblemDocumentBuilder.buildDocumentOf(new State(this.problems[0], ((ExtractionSolver)this.solvers[0]).getActiveConstraints(), false), true, false);
            assert (XMLProblemModifier.controlNamesInDocument(document));
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
            if (this.wcoreMode == 1) break;
            satisfiable = this.solveCurrentNetwork(num, false);
            assert (!satisfiable);
        }
        OutputManager.printInfo("Proof fixpoint reached");
        if (this.approach == Approach.MAX_CSP) {
            this.manageMaxCSP(num, true);
            return true;
        }
        if (this.approach == Approach.DEC_VAR) {
            return this.manageFixPoint(num, true);
        }
        if (this.approach == Approach.DEC_CON) {
            return this.manageFixPoint(num, false);
        }
        if (this.approach == Approach.INC || this.approach == Approach.INC_FIRST) {
            return this.findIncreasinglyDiagnosisElement(num);
        }
        if (this.approach == Approach.VARIABLE) {
            System.out.println("Variable approach starts");
            this.findVariablesOfCore(num, false);
            if (this.solveCurrentNetwork(num, true)) {
                System.out.println("PBBBBBBBBBBB");
            }
        }
        System.out.println("Constraint approach starts");
        this.findConstraintsOfCore(num, false);
        return true;
    }

    protected void solveInstance(int num) {
        outputManager.outputMap("resolution", new LinkedHashMap<String, String>(), 0);
        Stopwatch veryGlobalStopwatch = new Stopwatch();
        this.passNumber = 0;
        this.extractionNumber = 0;
        XMLProblemModifier.getCores().reset();
        int i = 0;
        while (i < this.nbSearchedCores) {
            if (!this.extractNextCore(num)) break;
            Document document = XMLProblemModifier.minus(this.getExtractionFileNameFor(this.passNumber, 0), this.getCurrentExtractionFileName());
            ++this.passNumber;
            this.extractionNumber = 0;
            XMLManipulation.saveInstance(document, this.getCurrentExtractionFileName());
            System.out.println("    New Core Ker" + i + " = " + XMLProblemModifier.getCores().getLast() + " in cpu = " + veryGlobalStopwatch.getCurrentWallClockTime() + " and nbRuns = " + ((ExtractionSolver)this.solvers[0]).getNbRuns());
            ++i;
        }
        this.updateGlobalStatistics(veryGlobalStopwatch.getCurrentWallClockTime());
    }

    protected void updateGlobalStatistics(long globalDuration) {
        super.updateGlobalStatistics();
        this.kernelStatistics.update(globalDuration);
    }

    protected void displayGlobalStatistics() {
        super.displayGlobalStatistics();
        this.kernelStatistics.display();
    }

    public static void main(String[] args) {
        ExtractionResolution.loadArgumentsAndConfiguration(args);
        ExtractionResolution resolution = new ExtractionResolution();
        resolution.solveInstances(0L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Approach {
        DEC_VAR,
        DEC_CON,
        VARIABLE,
        CONSTRAINT,
        INC,
        INC_FIRST,
        MAX_CSP;


        public static Approach getApproachFor(int idApproach) {
            if (idApproach == 0) {
                return DEC_VAR;
            }
            if (idApproach == 1) {
                return DEC_CON;
            }
            if (idApproach == 2) {
                return VARIABLE;
            }
            if (idApproach == 3) {
                return CONSTRAINT;
            }
            if (idApproach == 4) {
                return INC;
            }
            if (idApproach == 5) {
                return INC_FIRST;
            }
            if (idApproach == 6) {
                return MAX_CSP;
            }
            throw new UnreachableCodeException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VariableComparator
    implements Comparator<Variable> {
        VariableComparator() {
        }

        @Override
        public int compare(Variable variable1, Variable variable2) {
            if (ExtractionResolution.this.coreOfVariables.contains(variable1.getName())) {
                return -1;
            }
            if (ExtractionResolution.this.coreOfVariables.contains(variable2.getName())) {
                return 1;
            }
            double d1 = variable1.getWeightedDegreeOnDomainSize();
            double d2 = variable2.getWeightedDegreeOnDomainSize();
            if (d2 - d1 > 0.0) {
                return 1;
            }
            if (d2 - d1 < 0.0) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof VariableComparator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConstraintComparator
    implements Comparator<Constraint> {
        ConstraintComparator() {
        }

        @Override
        public int compare(Constraint constraint1, Constraint constraint2) {
            if (ExtractionResolution.this.coreOfConstraints.contains(constraint1.getName())) {
                return -1;
            }
            if (ExtractionResolution.this.coreOfConstraints.contains(constraint2.getName())) {
                return 1;
            }
            double d1 = constraint1.getWeightedDegree();
            double d2 = constraint2.getWeightedDegree();
            if (d2 - d1 > 0.0) {
                return 1;
            }
            if (d2 - d1 < 0.0) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ConstraintComparator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConstraintComparator2
    implements Comparator<Constraint> {
        ConstraintComparator2() {
        }

        @Override
        public int compare(Constraint constraint1, Constraint constraint2) {
            if (ExtractionResolution.this.coreOfConstraints.contains(constraint1.getName())) {
                return -1;
            }
            if (ExtractionResolution.this.coreOfConstraints.contains(constraint2.getName())) {
                return 1;
            }
            double d1 = constraint1.getNbEffectiveRevisions();
            double d2 = constraint2.getNbEffectiveRevisions();
            if (d2 - d1 > 0.0) {
                return 1;
            }
            if (d2 - d1 < 0.0) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ConstraintComparator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KernelStatistics {
        private String name = "kernelStatistics";
        private int nbInstances;
        double globalTime;
        int nbRuns;
        int nbCores;
        int nbVariablesOfMinCore;
        int nbConstraintsOfMinCore;
        int nbVariablesOfMaxCore;
        int nbConstraintsOfMaxCore;
        int nbVariablesOfAvgCore;
        int nbConstraintsOfAvgCore;
        String lastCores;

        KernelStatistics() {
        }

        void update(long globalDuration) {
            Cores cores = XMLProblemModifier.getCores();
            if (cores.getNbCores() > 0) {
                ++this.nbInstances;
                this.nbCores += cores.getNbCores();
                this.nbVariablesOfMinCore += cores.getMin().getNbVariables();
                this.nbConstraintsOfMinCore += cores.getMin().getNbConstraints();
                this.nbVariablesOfMaxCore += cores.getMax().getNbVariables();
                this.nbConstraintsOfMaxCore += cores.getMax().getNbConstraints();
                this.nbVariablesOfAvgCore += cores.getAvg().getNbVariables();
                this.nbConstraintsOfAvgCore += cores.getAvg().getNbConstraints();
                this.globalTime += (double)globalDuration;
                this.nbRuns += ((ExtractionSolver)ExtractionResolution.this.solvers[0]).getNbRuns();
                this.lastCores = cores.toString();
            }
        }

        public Map<String, String> getMapOfAttributes() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("nbInstances", String.valueOf(this.nbInstances));
            map.put("mode", String.valueOf(ConfigurationManager.getInt(0, "solver", "mode")));
            if (this.nbInstances != 0) {
                map.put("globalTime", String.valueOf(this.globalTime / (double)this.nbInstances));
                map.put("nbRuns", String.valueOf(this.nbRuns / this.nbInstances));
                map.put("nbCores", String.valueOf(this.nbCores / this.nbInstances));
                map.put("nbVMin", String.valueOf(this.nbVariablesOfMinCore / this.nbInstances));
                map.put("nbCMin", String.valueOf(this.nbConstraintsOfMinCore / this.nbInstances));
                map.put("nbVMax", String.valueOf(this.nbVariablesOfMaxCore / this.nbInstances));
                map.put("nbCMax", String.valueOf(this.nbConstraintsOfMaxCore / this.nbInstances));
                map.put("nbVAvg", String.valueOf(this.nbVariablesOfAvgCore / this.nbInstances));
                map.put("nbCAvg", String.valueOf((double)this.nbConstraintsOfAvgCore / (double)this.nbInstances));
                map.put("lastCores", this.lastCores);
            }
            return map;
        }

        void display() {
            outputManager.outputMap(this.name, this.getMapOfAttributes(), 0);
        }
    }
}

